/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCDirectInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    public static final OCDirectInheritorsSearch INSTANCE = new OCDirectInheritorsSearch();

    private OCDirectInheritorsSearch() {
    }

    public static Query<OCClassSymbol> search(OCClassDeclaration aClass) {
        Project project = aClass.getProject();
        return OCDirectInheritorsSearch.search(aClass.getName(), GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCProtocol, aClass instanceof OCImplementation);
    }

    public static Query<OCClassSymbol> search(OCClassSymbol aClass) {
        Project project = aClass.getProject();
        return OCDirectInheritorsSearch.search(aClass.getName(), GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCProtocolSymbol, aClass instanceof OCImplementationSymbol);
    }

    public static Query<OCClassSymbol> search(String className, GlobalSearchScope scope, Project project, boolean protocol, boolean preferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, protocol, project, preferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultSearcher());
    }

    private static class DefaultSearcher
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultSearcher() {
        }

        public void processQuery(@NotNull SearchParameters p, final @NotNull Processor<OCClassSymbol> consumer) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch$DefaultSearcher", "processQuery"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch$DefaultSearcher", "processQuery"));
            }
            final String superName = p.getClassName();
            final GlobalSearchScope scope = p.getScope();
            final boolean isProtocol = p.isProtocol();
            final boolean preferImplementations = p.isPreferImplementations();
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(p.getProject(), new Processor<OCSymbol>(){

                private boolean acceptsInterface(OCInterfaceSymbol symbol) {
                    if (scope.accept(symbol.getContainingFile())) {
                        if (isProtocol) {
                            List<String> protocols = symbol.getProtocolNames();
                            for (String protocol : protocols) {
                                if (!Comparing.equal((String)superName, (String)protocol)) continue;
                                return true;
                            }
                        } else if (Comparing.equal((String)superName, (String)symbol.getSuperClassName())) {
                            return true;
                        }
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    ProgressManager.checkCanceled();
                    if (symbol instanceof OCInterfaceSymbol) {
                        if (!this.acceptsInterface((OCInterfaceSymbol)symbol)) {
                            return true;
                        }
                        if (preferImplementations) {
                            OCImplementationSymbol implSymbol = ((OCInterfaceSymbol)symbol).getImplementation();
                            if (implSymbol != null) {
                                consumer.process((Object)implSymbol);
                            } else {
                                consumer.process((Object)((OCClassSymbol)symbol));
                            }
                        } else {
                            consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    } else if (symbol instanceof OCProtocolSymbol) {
                        List<String> protocols = ((OCProtocolSymbol)symbol).getProtocolNames();
                        for (String protocol : protocols) {
                            if (!Comparing.equal((String)superName, (String)protocol)) continue;
                            return consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    }
                    return true;
                }
            }, null);
        }
    }

    public static class SearchParameters {
        private final GlobalSearchScope myScope;
        private final String myClassName;
        private final boolean isProtocol;
        private final Project myProject;
        private final boolean myPreferImplementations;

        public SearchParameters(GlobalSearchScope scope, String className, boolean protocol, Project project, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.isProtocol = protocol;
            this.myProject = project;
            this.myPreferImplementations = preferImplementations;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.isProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }
    }
}

