/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(final @NotNull PsiElement subj, final @NotNull Processor<PsiElement> consumer) {
        if (subj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subj", "com/jetbrains/cidr/lang/search/OCDefinitionsSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCDefinitionsSearch", "execute"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (!(subj instanceof OCSymbolDeclarator)) {
                    return true;
                }
                Object symbol = ((OCSymbolDeclarator)subj).getSymbol();
                if (symbol == null) {
                    return true;
                }
                if (!(subj instanceof OCMethod || subj instanceof OCDeclarator && subj.getParent() instanceof OCFunctionDeclaration)) {
                    return OCDefinitionsSearch.processSymbolDefinition(symbol, (Processor<PsiElement>)consumer);
                }
                final OCSymbol selfDefinitionSymbol = symbol.getDefinitionSymbol();
                OCDefinitionsSearch.consume(consumer, selfDefinitionSymbol);
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, new Processor<OCSymbolWithParent>(){

                    public boolean process(OCSymbolWithParent symbol) {
                        return !symbol.isDefinition() && symbol.getDefinitionSymbol() != null || symbol == selfDefinitionSymbol || OCDefinitionsSearch.consume(consumer, symbol);
                    }
                }, false, true, false);
                return true;
            }
        });
    }

    private static boolean processSymbolDefinition(final OCSymbol symbol, final Processor<PsiElement> consumer) {
        if (symbol instanceof OCPropertySymbol) {
            return ((OCPropertySymbol)symbol).processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol accessor) {
                    return OCDefinitionsSearch.consume(consumer, accessor);
                }
            }, true) && ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)new Processor<OCSynthesizeSymbol>(){

                public boolean process(OCSynthesizeSymbol synthesize) {
                    return OCDefinitionsSearch.consume(consumer, synthesize);
                }
            });
        }
        if (symbol instanceof OCClassSymbol) {
            return symbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol curSymbol) {
                    if (curSymbol.equals(symbol) || curSymbol.isPredeclaration()) {
                        return true;
                    }
                    if (curSymbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)curSymbol).getImplementation(((OCInterfaceSymbol)curSymbol).getCategoryName()) != null) {
                        return true;
                    }
                    return OCDefinitionsSearch.consume(consumer, curSymbol);
                }
            }) && OCClassInheritorsSearch.search((OCClassSymbol)symbol).forEach((Processor)new Processor<OCClassSymbol>(){

                public boolean process(OCClassSymbol symbol) {
                    return OCDefinitionsSearch.consume(consumer, symbol);
                }
            });
        }
        if (symbol instanceof OCStructSymbol) {
            final ArrayList result2 = new ArrayList();
            symbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol _symbol) {
                    if (_symbol instanceof OCStructSymbol && !_symbol.isPredeclaration()) {
                        if (((OCStructSymbol)_symbol).getTemplateSpecialization() != null) {
                            if (!_symbol.isPredeclaration()) {
                                result2.add(_symbol);
                            }
                        } else {
                            result2.add(0, _symbol);
                        }
                    }
                    return true;
                }
            });
            for (OCSymbol found : result2) {
                OCDefinitionsSearch.consume(consumer, found);
            }
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    OCDefinitionsSearch.consume(consumer, symbol);
                    return true;
                }
            });
        }
        return true;
    }

    private static <T> boolean consume(Processor<T> consumer, OCSymbol subj) {
        if (subj == null) {
            return true;
        }
        Object psi = subj.locateDefinition();
        if (psi != null) {
            return consumer.process(psi);
        }
        return true;
    }
}

