/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCClassInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    public static final OCClassInheritorsSearch INSTANCE = new OCClassInheritorsSearch();

    private OCClassInheritorsSearch() {
    }

    public static Query<OCClassSymbol> search(OCClassDeclaration aClass) {
        Project project = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocol, GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementation);
    }

    public static Query<OCClassSymbol> search(OCClassSymbol aClass) {
        Project project = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocolSymbol, GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementationSymbol);
    }

    public static Query<OCClassSymbol> search(String className, boolean isProtocol, GlobalSearchScope scope, Project project, boolean myPreferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, isProtocol, project, myPreferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, final @NotNull Processor<OCClassSymbol> consumer) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$DefaultExecutor", "processQuery"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$DefaultExecutor", "processQuery"));
            }
            final GlobalSearchScope scope = p.getScope();
            Project project = p.getProject();
            final Stack names = new Stack();
            HashSet<Pair> processed = new HashSet<Pair>();
            names.push((Object)Pair.create((Object)p.getClassName(), (Object)p.isProtocol()));
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair name = (Pair)names.pop();
                if (!processed.add(name)) continue;
                Query<OCClassSymbol> search = OCDirectInheritorsSearch.search((String)name.getFirst(), GlobalSearchScope.allScope((Project)project), project, (Boolean)name.getSecond(), p.isPreferImplementations());
                search.forEach((Processor)new Processor<OCClassSymbol>(){

                    public boolean process(OCClassSymbol symbol) {
                        names.push((Object)Pair.create((Object)symbol.getName(), (Object)(symbol instanceof OCProtocolSymbol)));
                        return !scope.contains(symbol.getContainingFile()) || consumer.process((Object)symbol);
                    }
                });
            }
        }
    }

    public static class SearchParameters {
        private final GlobalSearchScope myScope;
        private final String myClassName;
        private final Project myProject;
        private boolean myProtocol;
        private final boolean myPreferImplementations;

        public SearchParameters(GlobalSearchScope scope, String className, boolean protocol, Project project, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.myProtocol = protocol;
            this.myProject = project;
            this.myPreferImplementations = preferImplementations;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.myProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }
    }
}

