/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProviders;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCResourceReferenceContributor
extends PsiReferenceContributor {
    private static final OCResourceCompletionProvider[] PROVIDERS;

    public static boolean processReferenceProviders(Processor<OCResourceCompletionProvider> processor2) {
        return ContainerUtil.process((Object[])PROVIDERS, processor2);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/cidr/lang/resolve/references/OCResourceReferenceContributor", "registerReferenceProviders"));
        }
        for (OCResourceCompletionProvider provider : PROVIDERS) {
            registrar.registerReferenceProvider(OCResourceReferenceContributor.isResourceReference(provider), (PsiReferenceProvider)provider);
        }
    }

    private static PsiElementPattern.Capture<OCLiteralExpression> isResourceReference(OCResourceCompletionProvider provider) {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(OCLiteralExpression.class).with((PatternCondition)new IsStringLiteral())).inside((ElementPattern)PlatformPatterns.psiElement(OCMessageArgument.class).with((PatternCondition)new IsResourceMethod(provider)));
    }

    static {
        ArrayList ps = ContainerUtil.newArrayList();
        for (OCResourceCompletionProviders each : (OCResourceCompletionProviders[])Extensions.getExtensions(OCResourceCompletionProviders.EP_NAME)) {
            ps.addAll(each.getProviders());
        }
        PROVIDERS = ps.toArray(new OCResourceCompletionProvider[ps.size()]);
    }

    private static class IsResourceMethod
    extends PatternCondition<OCMessageArgument> {
        private OCResourceCompletionProvider myProvider;

        public IsResourceMethod(OCResourceCompletionProvider provider) {
            super(null);
            this.myProvider = provider;
        }

        public boolean accepts(@NotNull OCMessageArgument argument, ProcessingContext context) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cidr/lang/resolve/references/OCResourceReferenceContributor$IsResourceMethod", "accepts"));
            }
            return argument.getArgumentSelector().getSelectorName().equals(this.myProvider.getArgumentSelector());
        }
    }

    public static class IsStringLiteral
    extends PatternCondition<OCLiteralExpression> {
        public IsStringLiteral() {
            super(null);
        }

        public boolean accepts(@NotNull OCLiteralExpression literal, ProcessingContext context) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/cidr/lang/resolve/references/OCResourceReferenceContributor$IsStringLiteral", "accepts"));
            }
            return OCElementUtil.getStringLiteral(literal) != null;
        }
    }
}

