/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceWithContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCPolyVariantReferenceImpl<T extends OCSymbol>
implements OCPolyVariantReferenceWithContext<T> {
    public PsiElement resolve() {
        T symbol = this.resolveToSymbol();
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    @Override
    @Nullable
    public T resolveToSymbol() {
        return (T)((OCSymbol)ContainerUtil.getFirstItem(this.resolveToSymbols()));
    }

    @Override
    @Nullable
    public T resolveToSymbol(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/references/OCPolyVariantReferenceImpl", "resolveToSymbol"));
        }
        return (T)((OCSymbol)ContainerUtil.getFirstItem(this.resolveToSymbols(context)));
    }

    @Override
    @NotNull
    public List<T> resolveToSymbols(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/references/OCPolyVariantReferenceImpl", "resolveToSymbols"));
        }
        List list = this.resolveToSymbols();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCPolyVariantReferenceImpl", "resolveToSymbols"));
        }
        return list;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator)) {
            return false;
        }
        return this.resolveToSymbols().contains(((OCSymbolDeclarator)element).getSymbol());
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCPolyVariantReferenceImpl", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List symbols = this.resolveToSymbols();
        ArrayList<PsiElementResolveResult> answer = new ArrayList<PsiElementResolveResult>();
        for (OCSymbol symbol : symbols) {
            Object element = symbol.locateDefinition();
            if (element == null) continue;
            answer.add(new PsiElementResolveResult(element, true));
        }
        ResolveResult[] resolveResultArray = answer.toArray(new ResolveResult[answer.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCPolyVariantReferenceImpl", "multiResolve"));
        }
        return resolveResultArray;
    }
}

