/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCOperatorReference
extends OCPolyVariantReferenceImpl<OCSymbol> {
    private final OCElement myElement;
    private final String mySign;
    private final List<OCExpression> myArguments;
    private List<OCType> myParamTypes;
    private final TextRange myRange;
    private static Key<MyResolver> RESOLVER_KEY = Key.create((String)"RESOLVER_KEY");

    public OCOperatorReference(OCElement element, String sign, TextRange range, OCExpression ... params) {
        this.myElement = element;
        this.mySign = sign;
        this.myArguments = Arrays.asList(params);
        this.myRange = range;
    }

    public OCOperatorReference(OCElement element, String sign, TextRange range, List<OCExpression> arguments, List<OCType> paramTypes) {
        this.myElement = element;
        this.mySign = sign;
        this.myArguments = arguments;
        this.myParamTypes = paramTypes;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = new Object[]{};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCOperatorReference reference = (OCOperatorReference)o;
        if (this.myElement != null ? !this.myElement.equals(reference.myElement) : reference.myElement != null) {
            return false;
        }
        if (this.myRange != null ? !this.myRange.equals((Object)reference.myRange) : reference.myRange != null) {
            return false;
        }
        return !(this.mySign != null ? !this.mySign.equals(reference.mySign) : reference.mySign != null);
    }

    public int hashCode() {
        int result2 = this.myElement != null ? this.myElement.hashCode() : 0;
        result2 = 31 * result2 + (this.mySign != null ? this.mySign.hashCode() : 0);
        result2 = 31 * result2 + (this.myRange != null ? this.myRange.hashCode() : 0);
        return result2;
    }

    public List<OCExpression> getArgumentExpressions() {
        return this.myArguments;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.mySign;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "bindToSymbol"));
        }
        return this.handleElementRename(symbol.getName());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "bindToElement"));
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    @NotNull
    private List<OCSymbol> resolveToSymbols(@NotNull MyResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        Pair<List<OCSymbol>, Boolean> pair = ResolveCache.getInstance(this.myElement.getProject()).resolveWithCaching(this, resolver, false, false);
        List list = pair != null ? (List)pair.getFirst() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        return list;
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads) {
        List<OCSymbol> list = this.resolveToSymbols(MyResolver.getInstance(resolveOverloads));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        return list;
    }

    public boolean hasMagicOperands() {
        Pair<List<OCSymbol>, Boolean> pair = ResolveCache.getInstance(this.myElement.getProject()).resolveWithCaching(this, MyResolver.getInstance(true), false, false);
        return pair != null ? (Boolean)pair.getSecond() : false;
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        ArrayList<OCSymbol> arrayList = new ArrayList<OCSymbol>(this.resolveToSymbols(true));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        MyResolver resolver;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        OCResolveContext oCResolveContext = context;
        synchronized (oCResolveContext) {
            resolver = (MyResolver)context.getUserData(RESOLVER_KEY);
            if (resolver == null) {
                resolver = new MyResolver(true, context);
                context.putUserData(RESOLVER_KEY, resolver);
            }
        }
        List<OCSymbol> list = this.resolveToSymbols(resolver);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference", "resolveToSymbols"));
        }
        return list;
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<OCOperatorReference, Pair<List<OCSymbol>, Boolean>> {
        private boolean myResolveOverloads;
        private OCResolveContext myContext;
        private static final MyResolver[] INSTANCES = new MyResolver[]{new MyResolver(false), new MyResolver(true)};
        private static final Pair<List<OCSymbol>, Boolean> EMPTY = new Pair(Collections.emptyList(), (Object)false);
        private static final Pair<List<OCSymbol>, Boolean> EMPTY_MAGIC = new Pair(Collections.emptyList(), (Object)true);

        public static MyResolver getInstance(boolean resolveOverloads) {
            return resolveOverloads ? INSTANCES[1] : INSTANCES[0];
        }

        private MyResolver(boolean resolveOverloads, @NotNull OCResolveContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver", "<init>"));
            }
            this.myResolveOverloads = resolveOverloads;
            this.myContext = context;
        }

        private MyResolver(boolean resolveOverloads) {
            this.myResolveOverloads = resolveOverloads;
        }

        @Override
        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver", "resolve"));
            }
            return this.resolve(reference, this.myContext != null ? this.myContext : new OCResolveContext(reference.getElement()));
        }

        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, @NotNull OCResolveContext context) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver", "resolve"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/resolve/references/OCOperatorReference$MyResolver", "resolve"));
            }
            OCFile file2 = reference.myElement.getContainingOCFile();
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCExpression> args = new ArrayList<OCExpression>();
            boolean hasCppStructType = false;
            boolean wasNonLiteral = false;
            boolean hasMagicParameter = false;
            for (Object param : reference.myArguments) {
                if (param instanceof OCLiteralExpression) continue;
                wasNonLiteral = true;
            }
            if (!wasNonLiteral) {
                return EMPTY;
            }
            for (int i = 0; i < reference.myArguments.size(); ++i) {
                OCExpression expr = (OCExpression)reference.myArguments.get(i);
                OCType type = reference.myParamTypes != null && i < reference.myParamTypes.size() ? ((OCType)reference.myParamTypes.get(i)).resolve(file2) : expr.getResolvedType(context);
                args.add(expr);
                if (type instanceof OCCppReferenceType) {
                    type = ((OCCppReferenceType)type).getRefType();
                }
                if (type instanceof OCMagicType) {
                    hasMagicParameter = true;
                }
                if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT) {
                    hasCppStructType = true;
                }
                types.add(type);
            }
            if (hasCppStructType) {
                String name = "operator" + reference.mySign;
                OCType leftType = (OCType)types.get(0);
                CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                if (leftType instanceof OCCppReferenceType) {
                    leftType = ((OCCppReferenceType)leftType).getRefType();
                }
                if (leftType instanceof OCStructType) {
                    List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)leftType, name, null, context);
                    ContainerUtil.process(members, (Processor)collector);
                }
                OCSymbolReference.getLocalReference(name, reference.getElement()).processPossibleSymbols((Processor<OCSymbol>)collector, file2);
                for (OCType type : types) {
                    OCSymbolWithQualifiedName parent;
                    OCType terminalType = type.getTerminalType();
                    if (!(terminalType instanceof OCStructType) || (parent = ((OCStructType)terminalType).getSymbol().getParent()) == null) continue;
                    OCSymbolReference.getGlobalReference(name, parent).processPossibleSymbols((Processor<OCSymbol>)collector, file2);
                }
                Collection<OCSymbol> symbols = OCArgumentDepLookupAccumulator.doArgDepLookup(collector.getResults(), types, args, OCQualifiedName.with(name), file2);
                if (this.myResolveOverloads) {
                    OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(symbols, types, args, leftType.getCVQualifiers(), context, reference, true, true, false);
                    if (result2 != null) {
                        return new Pair(Collections.singletonList(result2), (Object)hasMagicParameter);
                    }
                    return EMPTY;
                }
                return new Pair((Object)((List)collector.getResults()), (Object)hasMagicParameter);
            }
            return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
        }
    }
}

