/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.resolve.references.CompositeResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompositeResourceReference
implements OCResourceReference {
    private static final Function<OCResourceReference, PsiElement> ELEMENT = new Function<OCResourceReference, PsiElement>(){

        public PsiElement fun(OCResourceReference reference) {
            return reference.getElement();
        }
    };
    private static final Function<OCResourceReference, Class> CLASS = new Function<OCResourceReference, Class>(){

        public Class fun(OCResourceReference reference) {
            return reference.getClass();
        }
    };
    private final List<OCResourceReference> myReferences;

    public OCCompositeResourceReference(List<OCResourceReference> references) {
        CompositeResourceCompletionProvider.assertSameValue(references, CLASS);
        CompositeResourceCompletionProvider.assertSameValue(references, ELEMENT);
        this.myReferences = references;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(boolean includeQuotes) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        for (OCResourceReference reference : this.myReferences) {
            result2.addAll(reference.getLookupElements(includeQuotes));
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference", "getLookupElements"));
        }
        return arrayList;
    }

    @Nullable
    public PsiElement resolve() {
        Pair<PsiElement, ? extends PsiReference> result2 = this.resolveInner();
        return result2 == null ? null : (PsiElement)result2.first;
    }

    private Pair<PsiElement, ? extends PsiReference> resolveInner() {
        for (OCResourceReference reference : this.myReferences) {
            PsiElement element = reference.resolve();
            if (element == null) continue;
            return Pair.create((Object)element, (Object)reference);
        }
        return null;
    }

    public PsiElement getElement() {
        return this.getRepresentative().getElement();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        return resolve == null ? null : ((PsiReference)resolve.second).handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference", "bindToElement"));
        }
        return this.getRepresentative().bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        for (OCResourceReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        for (OCResourceReference reference : this.myReferences) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public TextRange getRangeInElement() {
        return this.getRepresentative().getRangeInElement();
    }

    @NotNull
    public String getCanonicalText() {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        String string = resolve == null ? this.getRepresentative().getCanonicalText() : ((PsiReference)resolve.second).getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public PsiReference getRepresentative() {
        PsiReference psiReference = this.myReferences.get(0);
        if (psiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference", "getRepresentative"));
        }
        return psiReference;
    }
}

