/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCFileReferenceHelper
extends FileReferenceHelper {
    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/resolve/OCFileReferenceHelper", "isMine"));
        }
        return file2.getFileType() == OCFileType.INSTANCE;
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/cidr/lang/resolve/OCFileReferenceHelper", "trimUrl"));
        }
        String string = url.trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/OCFileReferenceHelper", "trimUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/resolve/OCFileReferenceHelper", "getContexts"));
        }
        ArrayList<PsiFileSystemItem> roots = new ArrayList<PsiFileSystemItem>();
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file2);
        if (item != null) {
            roots.add(item.getParent());
        }
        OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file2, project);
        for (PsiFileSystemItem psiFileSystemItem : rootAndConfiguration.getLibraryHeadersRoots().getRoots()) {
            if (!psiFileSystemItem.isValid()) continue;
            roots.add(psiFileSystemItem);
        }
        OCIncludeHelpers.processContainingFramework(project, file2, (Processor<PsiFileSystemItem>)new CommonProcessors.CollectProcessor(roots));
        roots.addAll(rootAndConfiguration.getProjectHeadersRoots().getRoots());
        ArrayList<PsiFileSystemItem> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/resolve/OCFileReferenceHelper", "getContexts"));
        }
        return arrayList;
    }
}

