/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @Override
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file2) {
        PsiReference reference;
        OCSymbol symbol;
        if (!(file2 instanceof OCFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (element == null) {
            PsiReference reference2 = TargetElementUtil.findReference(editor, offset);
            element = reference2 != null ? reference2.getElement() : null;
            return element instanceof OCReferenceElement || element instanceof OCQualifiedExpression;
        }
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        if (element instanceof OCDefineDirective && element.getTextRange().containsOffset(offset) && !((OCDefineDirective)element).getNameIdentifier().getTextRange().containsOffset(offset)) {
            return false;
        }
        if (element instanceof OCMethod) {
            OCMethodSymbol symbol2 = (OCMethodSymbol)((OCMethod)element).getSymbol();
            OCMethodSymbol oCMethodSymbol = symbol2 = symbol2 != null ? symbol2.getAssociatedSymbol() : null;
            if (symbol2 != null && symbol2.getGeneratedFromProperty() != null) {
                return false;
            }
        } else if (element instanceof OCDeclarator && (symbol = ((OCDeclarator)element).getSymbol()) instanceof OCPropertySymbol && (reference = TargetElementUtil.findReference(editor, offset)) != null && reference.getElement() instanceof OCSendMessageExpression && !symbol.getName().equals(((OCSendMessageExpression)reference.getElement()).getMessageSelector())) {
            return false;
        }
        return element instanceof OCCategoryName && !((OCCategoryName)element).getName().isEmpty() || element instanceof OCSymbolDeclarator && (element instanceof PsiNamedElement || element instanceof OCReferenceElement) && element.getLanguage() == OCLanguage.getInstance();
    }

    @Override
    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenameHandler", "createRenamer"));
        }
        return OCInplaceRenameHandler.createRenamer(elementToRename, editor, null, null);
    }

    @Nullable
    static VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor, @Nullable String initialName, @Nullable String oldName) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenameHandler", "createRenamer"));
        }
        if (elementToRename instanceof OCCategoryName) {
            OCClassSymbol symbol = ((OCClassDeclaration)elementToRename.getParent()).getSymbol();
            if (symbol != null) {
                return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, true, initialName, oldName);
            }
        } else {
            PsiElement element;
            Object symbol = ((OCSymbolDeclarator)elementToRename).getSymbol();
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)elementToRename.getProject()).getPsiFile(editor.getDocument());
            PsiElement psiElement = element = currentFile != null ? currentFile.findElementAt(editor.getCaretModel().getOffset()) : null;
            if (currentFile != null && OCElementUtil.getElementType(element) != OCTokenTypes.IDENTIFIER) {
                element = currentFile.findElementAt(editor.getCaretModel().getOffset() - 1);
            }
            if (elementToRename instanceof OCMethod) {
                OCMethod method = (OCMethod)elementToRename;
                if (symbol instanceof OCMethodSymbol && element != null && OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER) {
                    PsiElement parent = element.getParent();
                    OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol;
                    int index = -1;
                    if (parent instanceof OCMethodSelectorPart && ((OCMethodSelectorPart)parent).getSelectorIdentifier() == element) {
                        index = method.getSelectors().indexOf(element);
                    } else if (parent instanceof OCArgumentSelector && ((OCArgumentSelector)parent).getSelectorIdentifier() == element) {
                        OCSendMessageExpression sendMessageExpr = (OCSendMessageExpression)parent.getParent().getParent();
                        index = sendMessageExpr.getArgumentSelectors().indexOf(parent);
                    } else if (parent instanceof OCQualifiedExpression) {
                        index = 0;
                    } else if (parent instanceof OCSelectorExpression) {
                        index = ((OCSelectorExpression)parent).getSelectorParts().indexOf(element);
                    }
                    if (index != -1) {
                        return new OCInplaceRenamer(method, methodSymbol, element, index, editor, initialName, oldName);
                    }
                }
                return new OCInplaceRenamer((OCMethod)elementToRename, (OCSymbol)symbol, editor, false, initialName, oldName){

                    @Override
                    public boolean performInplaceRename() {
                        return true;
                    }
                };
            }
            if (symbol instanceof OCInstanceVariableSymbol && elementToRename instanceof OCReferenceElement) {
                return new OCInplaceRenamer(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol), (OCSymbol)symbol, editor, false, initialName, oldName);
            }
            if (symbol instanceof OCPropertySymbol && element != null && element.getParent() instanceof OCSelectorExpression && OCNameSuggester.isObjCSetter(((OCSelectorExpression)element.getParent()).getSelector())) {
                return null;
            }
            if (symbol != null) {
                if (elementToRename instanceof OCLocalizedString) {
                    int offset;
                    if (OCElementUtil.getElementType(elementToRename.getFirstChild()) != OCTokenTypes.STRING_LITERAL || ((OCLocalizedString)elementToRename).getKey().isEmpty()) {
                        return null;
                    }
                    if (currentFile != null && (element = currentFile.findElementAt(offset = editor.getCaretModel().getOffset())) != null && OCElementUtil.getElementType(element) == OCTokenTypes.STRING_LITERAL && offset == element.getTextOffset()) {
                        editor.getCaretModel().moveToOffset(offset + 1);
                    }
                }
                return new OCInplaceRenamer((PsiNamedElement)elementToRename, (OCSymbol)symbol, editor, false, initialName, oldName);
            }
        }
        return null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenameHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement psiElement = element = dataContext != null ? PsiElementRenameHandler.getElement(dataContext) : null;
        if (element == null) {
            PsiReference reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            PsiElement psiElement2 = element = reference != null && reference.resolve() == null ? reference.getElement() : null;
            if (element != null) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                if (ApplicationManager.getApplication().isUnitTestMode() || this.checkAvailable(element, editor, dataContext)) {
                    String initialName = dataContext != null ? (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext) : null;
                    OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(editor, file2, project, reference, initialName, reference.getCanonicalText());
                    ((VariableInplaceRenamer)renamer).performInplaceRename();
                }
                return;
            }
        }
        super.invoke(project, editor, file2, dataContext);
    }

    @Override
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, Editor editor, @Nullable DataContext dataContext) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenameHandler", "doRename"));
        }
        VariableInplaceRenamer renamer = this.createRenamer(elementToRename, editor);
        if (renamer != null) {
            renamer.performInplaceRename();
        }
        return renamer;
    }
}

