/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractExtractDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractSuperProtocolDialog
extends OCAbstractExtractDialog {
    public OCExtractSuperProtocolDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/refactoring/move/ui/OCExtractSuperProtocolDialog", "<init>"));
        }
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle("Extract Super Protocol");
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "Extract_Protocol_Dialog";
    }

    @Override
    protected String getClassType() {
        return "Super Protocol";
    }

    @Override
    protected OCSymbolKind getSymbolKind() {
        return OCSymbolKind.PROTOCOL;
    }

    @Override
    protected OCMoveProcessor createProcessor() {
        return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

            @Override
            protected OCNewFileActionBase getNewClassAction() {
                return new OCNewProtocolAction();
            }

            @Override
            public void addSuperClasses() {
                this.myMover.addBaseProtocol(this.myMainInterface, this.myTargetClassName);
            }

            @Override
            protected boolean importTargetFromSource() {
                return true;
            }

            @Override
            protected String getCommandName() {
                return OCExtractSuperProtocolDialog.this.getTitle();
            }
        };
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            @Override
            public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
                if (memberInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfo", "com/jetbrains/cidr/lang/refactoring/move/ui/OCExtractSuperProtocolDialog$2", "checkForProblems"));
                }
                return 0;
            }

            @Override
            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCExtractSuperProtocolDialog.this.isMemberEnabled(member);
            }
        };
    }

    @Override
    protected boolean isMemberEnabled(OCMemberInfo member) {
        return !(member.getSymbol() instanceof OCInstanceVariableSymbol);
    }
}

