/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveTopLevelRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveTopLevelRefactoringHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveTopLevelRefactoringHandler", "invoke"));
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        final HashSet<PsiElement> set = new HashSet<PsiElement>(Arrays.asList(elements));
        this.showDialog(elements[0], new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return set.contains(element);
            }
        }, editor);
    }

    public void invoke(@NotNull Project project, Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveTopLevelRefactoringHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        if (element == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            final TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            this.showDialog(element, new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    return element != null && file2.equals(element.getContainingFile()) && selectionRange.contains(element.getTextRange());
                }
            }, editor);
        } else {
            this.showDialog(element, new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    return element != null && file2.equals(element.getContainingFile()) && element.getTextRange().containsOffset(offset);
                }
            }, editor);
        }
    }

    protected void showDialog(PsiElement element, Condition<PsiElement> selectedCond, Editor editor) {
        OCAbstractMoveDialog dialog;
        Project project = element.getProject();
        if (!OCSearchScope.isInProjectSources(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)this.getTitle(), null);
            return;
        }
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        OCAbstractMoveDialog oCAbstractMoveDialog = dialog = parent instanceof OCCppNamespace ? this.createDialog((OCCppNamespace)parent, selectedCond) : this.createDialog((OCFile)parent, selectedCond);
        if (dialog == null) {
            return;
        }
        if (!dialog.allowsEmptySelection() && dialog.getMemberInfos().isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)((parent instanceof OCCppNamespace ? "Namespace \"" : "File \"") + parent.getName() + "\" has no members to move"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getTitle(), null);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Pair<OCFile[], String> pair = dialog.invokeRefactoring();
            this.passToTest((String)pair.getSecond(), (OCFile[])pair.getFirst());
            return;
        }
        dialog.show();
    }

    protected void passToTest(String conflicts, OCFile[] newFiles) {
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return true;
    }

    protected abstract String getTitle();

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCFile var1, Condition<PsiElement> var2);

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCCppNamespace var1, Condition<PsiElement> var2);
}

