/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveTopLevelRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCMoveMembersDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCMoveTopLevelDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import org.jetbrains.annotations.Nullable;

public class OCMoveHandlerDelegate
extends MoveHandlerDelegate {
    private static OCMoveRefactoringHandler myMembersHandler = new MoveMembersHandler();
    private static OCMoveTopLevelRefactoringHandler myTopLevelHandler = new MoveTopLevelHandler();

    private static boolean isTopLevelHandlerApplicable(PsiElement element) {
        return !(element instanceof PsiFileSystemItem) && element.getContainingFile() instanceof OCFile;
    }

    private static boolean isMembersHandlerApplicable(PsiElement element) {
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class, OCStruct.class});
        PsiElement nameIdentifier = parent != null ? parent.getNameIdentifier() : null;
        return nameIdentifier != null && nameIdentifier.getTextRange().getEndOffset() < element.getTextOffset();
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        if (OCMoveHandlerDelegate.isMembersHandlerApplicable(element)) {
            myMembersHandler.invoke(project, editor, element.getContainingFile(), dataContext);
            return true;
        }
        if (OCMoveHandlerDelegate.isTopLevelHandlerApplicable(element)) {
            myTopLevelHandler.invoke(project, editor, element.getContainingFile(), dataContext);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        PsiElement source = sources[0];
        if (OCMoveHandlerDelegate.isMembersHandlerApplicable(source)) {
            PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)source, (Class[])new Class[]{OCClassDeclaration.class, OCStruct.class});
            if (parent instanceof OCClassDeclaration) {
                return psiElement instanceof OCClassDeclaration;
            }
            if (parent instanceof OCStruct) {
                return psiElement instanceof OCStruct;
            }
            return false;
        }
        if (OCMoveHandlerDelegate.isTopLevelHandlerApplicable(source)) {
            return psiElement.getContainingFile() instanceof OCFile;
        }
        return false;
    }

    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        PsiElement source = elements[0];
        return OCMoveHandlerDelegate.isMembersHandlerApplicable(source) || OCMoveHandlerDelegate.isTopLevelHandlerApplicable(source);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        PsiElement source = elements[0];
        if (OCMoveHandlerDelegate.isMembersHandlerApplicable(source)) {
            myMembersHandler.invoke(project, elements, null);
        } else if (OCMoveHandlerDelegate.isTopLevelHandlerApplicable(source)) {
            myTopLevelHandler.invoke(project, elements, null);
        }
    }

    public static class MoveTopLevelHandler
    extends OCMoveTopLevelRefactoringHandler {
        private String myTargetFileName;

        public MoveTopLevelHandler() {
        }

        public MoveTopLevelHandler(String targetFileName) {
            this.myTargetFileName = targetFileName;
        }

        @Override
        protected String getTitle() {
            return RefactoringBundle.message((String)"move.members.title");
        }

        @Override
        @Nullable
        protected OCAbstractMoveDialog createDialog(OCFile file2, Condition<PsiElement> selectedCondition) {
            return new OCMoveTopLevelDialog(file2, selectedCondition, this.myTargetFileName);
        }

        @Override
        @Nullable
        protected OCAbstractMoveDialog createDialog(OCCppNamespace namespace, Condition<PsiElement> selectedCondition) {
            return new OCMoveTopLevelDialog(namespace, (OCNamespaceSymbol)namespace.getSymbol(), selectedCondition, this.myTargetFileName);
        }
    }

    public static class MoveMembersHandler
    extends OCMoveRefactoringHandler {
        private String myTargetClassName;

        public MoveMembersHandler() {
        }

        public MoveMembersHandler(String name) {
            this.myTargetClassName = name;
        }

        @Override
        protected String getTitle() {
            return RefactoringBundle.message((String)"move.members.title");
        }

        @Override
        protected OCAbstractMoveDialog createDialog(OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Editor editor) {
            return new OCMoveMembersDialog(clazz, classSymbol, selectedCondition, this.myTargetClassName);
        }
    }
}

