/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCMoveRefactoringHandler;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCExtractSuperProtocolDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;

public class OCExtractSuperProtocolHandler
extends OCMoveRefactoringHandler {
    @Override
    protected String getTitle() {
        return "Extract Super Protocol";
    }

    @Override
    protected void showDialog(OCSymbolDeclarator clazz, Condition<PsiElement> selectedCond, Editor editor) {
        OCInterfaceSymbol mainInterface;
        Project project = clazz.getProject();
        Object symbol = clazz.getSymbol();
        if (symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null && (mainInterface = ((OCClassSymbol)symbol).getMainInterface()) != null && !OCSearchScope.isInProjectSources(mainInterface)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("refactoring.category.not.in.project", new Object[0]), (String)this.getTitle(), null);
            return;
        }
        super.showDialog(clazz, selectedCond, editor);
    }

    @Override
    protected OCAbstractMoveDialog createDialog(OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Editor editor) {
        return new OCExtractSuperProtocolDialog(clazz, classSymbol, selectedCondition);
    }

    @Override
    protected boolean acceptsElement(PsiElement element) {
        if (element instanceof OCDeclarator) {
            OCSymbol symbol = ((OCDeclarator)element).getSymbol();
            return symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCPropertySymbol;
        }
        return element instanceof OCClassDeclaration || element instanceof OCMethod || element instanceof OCProperty;
    }
}

