/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OCTopLevelTarget
extends OCTargetClass<PsiElement, OCSymbol> {
    private OCFile myImplementationFile;
    private OCFile mySourceFile;

    public OCTopLevelTarget(OCFile sourceFile, OCFile file2, Set<VirtualFile> files, Project project) {
        super(file2.getName(), files, null, null, project);
        this.mySourceFile = sourceFile;
        this.myPsi = file2;
        this.mySymbol = OCNamespaceSymbol.createGlobalNamespaceSymbol(file2);
        this.myStorage = new OCMemberInfoStorage(file2);
        this.myStorage.getClassMemberInfos(file2);
    }

    @Override
    public String getDisplayName() {
        return "file \"" + ((OCFile)this.myPsi).getName() + "\"";
    }

    @Override
    public void locateTargetClass() {
        OCFile associatedFile;
        this.myStorage = new OCMemberInfoStorage(this.myPsi);
        this.myMembersMap.clear();
        for (OCMemberInfo info : this.myStorage.getClassMemberInfos(this.myPsi)) {
            Object element = info.getSymbol().locateDefinition();
            if (element == null) continue;
            this.myMembersMap.put(info, element);
        }
        if (((OCFile)this.myPsi).isHeader() && !this.mySourceFile.equals(associatedFile = ((OCFile)this.myPsi).getAssociatedFile())) {
            this.myImplementationFile = associatedFile;
            if (this.myImplementationFile == null) {
                ((OCFile)this.myPsi).getMembersContainer(false).processMembers(null, new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (!Comparing.equal((Object)symbol.getContainingFile(), (Object)((OCFile)OCTopLevelTarget.this.myPsi).getVirtualFile())) {
                            return true;
                        }
                        if (symbol instanceof OCSymbolWithParent) {
                            if ((symbol = symbol.getAssociatedSymbol()) != null) {
                                OCTopLevelTarget.this.myImplementationFile = symbol.getContainingOCFile();
                            }
                            if (OCTopLevelTarget.this.myImplementationFile != null && OCTopLevelTarget.this.myImplementationFile != OCTopLevelTarget.this.myPsi) {
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
        }
        if (this.myImplementationFile == null) {
            this.myImplementationFile = (OCFile)this.myPsi;
        }
    }

    @Override
    @Nullable
    protected VirtualFile getTargetFile(PsiElement element, OCSymbol symbol) {
        if (((OCFile)element.getContainingFile()).isHeader()) {
            return this.myPsi.getContainingFile().getVirtualFile();
        }
        return this.myImplementationFile.getVirtualFile();
    }

    @Override
    @Nullable
    protected OCSymbolDeclarator addMember(PsiElement element, OCSymbol symbol, @Nullable OCVisibility visibility) {
        PsiElement newElement = OCChangeUtil.add((PsiElement)(((OCFile)element.getContainingFile()).isHeader() ? this.myPsi : this.myImplementationFile), element);
        if (newElement instanceof OCSymbolDeclarator) {
            return (OCSymbolDeclarator)newElement;
        }
        if (newElement instanceof OCDeclaration) {
            List<OCDeclarator> declarators = ((OCDeclaration)newElement).getDeclarators();
            if (declarators.isEmpty()) {
                OCTypeElement typeElement = ((OCDeclaration)newElement).getTypeElement();
                if (typeElement != null) {
                    for (PsiElement child : typeElement.getChildren()) {
                        if (!(child instanceof OCSymbolDeclarator)) continue;
                        return (OCSymbolDeclarator)child;
                    }
                }
            } else {
                return declarators.get(0);
            }
        }
        return null;
    }
}

