/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBaseInplaceIntroducer<V extends PsiNameIdentifierOwner, E extends PsiElement>
extends AbstractInplaceIntroducer<V, E> {
    private RangeMarker myVarMarker;
    protected PsiFile myVarFile;
    private Class<V> myVariableClass;
    private boolean myCreateFromUsageMode;
    protected OCSymbol myParentSymbol;
    protected String myUsageName;
    protected OCType myExprType;
    protected String myOldDocumentText;
    protected JCheckBox myPutToHeaderCb;
    protected List<MyPsiPointer> myOccurrencePtrs;
    protected MyPsiPointer myExprPtr;
    private MyPsiPointer myAnchorPtr;

    public OCBaseInplaceIntroducer(Project project, Editor editor, E expression, List<E> occurrences, Class<V> variableClass, Class<E> expressionClass, String refactoringName) {
        super(project, editor, expression, null, (PsiElement[])ContainerUtil.toArray(occurrences, (Object[])((PsiElement[])Array.newInstance(expressionClass, occurrences.size()))), refactoringName, (FileType)OCFileType.INSTANCE);
        this.myVariableClass = variableClass;
        this.myExprPtr = new MyPsiPointer((PsiElement)expression);
    }

    public void configurePanel() {
        PsiElement parent;
        if (!this.isPreviewDisabled()) {
            this.myWholePanel.add(this.getPreviewComponent());
        }
        if ((parent = this.myAnchorPtr.getElement().getParent()) instanceof OCFile && !((OCFile)parent).isHeader() && ((OCFile)parent).getAssociatedFile() != null) {
            final OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(OCCodeStyleSettings.class);
            this.myPutToHeaderCb = this.createCheckBox("Put to &header", settings.INTRODUCE_GLOBALS_TO_HEADER, new Runnable(){

                @Override
                public void run() {
                    settings.INTRODUCE_GLOBALS_TO_HEADER = OCBaseInplaceIntroducer.this.myPutToHeaderCb.isSelected();
                }
            });
        }
    }

    protected NonFocusableCheckBox createCheckBox(String caption, boolean selected, final @Nullable Runnable listener) {
        return OCBaseInplaceIntroducer.createCheckBox(this.myProject, this.myTitle, this.myWholePanel, caption, selected, new Processor<Boolean>(){

            public boolean process(Boolean aBoolean) {
                if (listener != null) {
                    listener.run();
                }
                return true;
            }
        });
    }

    public static NonFocusableCheckBox createCheckBox(final Project project, final String actionTitle, JPanel panel, String caption, boolean selected, final @Nullable Processor<Boolean> listener) {
        final NonFocusableCheckBox checkBox = new NonFocusableCheckBox(caption);
        checkBox.setSelected(selected);
        DialogUtil.registerMnemonic((AbstractButton)checkBox, (char)'&');
        OCBaseInplaceIntroducer.addControl(panel, (JComponent)checkBox);
        if (listener != null) {
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new WriteCommandAction(project, actionTitle, actionTitle, new PsiFile[0]){

                        protected void run(@NotNull Result result2) throws Throwable {
                            if (result2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer$3$1", "run"));
                            }
                            listener.process((Object)checkBox.isSelected());
                        }
                    }.execute();
                }
            });
        }
        return checkBox;
    }

    protected static void addControl(JPanel panel, JComponent checkBox) {
        int controlsCnt = panel.getComponentCount();
        panel.add((Component)checkBox, new GridBagConstraints(0, controlsCnt++, 1, 1, 1.0, 0.0, 18, 0, new Insets(controlsCnt > 0 ? 0 : 5, 5, 5, 5), 0, 0));
        controlsCnt = panel.getComponentCount();
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, controlsCnt, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setCreateFromUsageMode(boolean createFromUsageMode) {
        this.myCreateFromUsageMode = createFromUsageMode;
    }

    protected boolean isCreateFromUsageMode() {
        return this.myCreateFromUsageMode;
    }

    public void setParentSymbol(OCSymbol parentSymbol) {
        this.myParentSymbol = parentSymbol;
    }

    public void setUsageName(String usageName) {
        this.myUsageName = usageName;
    }

    @Override
    protected RangeMarker createMarker(PsiElement element) {
        return this.myEditor.getDocument().createRangeMarker(OCElementUtil.getRangeWithMacros(element));
    }

    protected boolean changeUsages(String newName) {
        return !this.isCreateFromUsageMode() || !newName.equals(this.myUsageName);
    }

    public void setExprType(OCType exprType) {
        if (exprType != null) {
            this.myExprType = exprType;
        }
    }

    protected boolean isPreviewDisabled() {
        return false;
    }

    @Override
    protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
        for (PsiElement expression : this.getOccurrences()) {
            if (!expression.isValid()) continue;
            OCMacroCall macroCall = OCElementUtil.getElementMacroCall(expression);
            TextRange range = OCElementUtil.getRangeWithMacros(expression);
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)(macroCall != null ? macroCall : expression), (Object)new TextRange(0, range.getLength())));
        }
    }

    @Override
    @Nullable
    protected V getVariable() {
        PsiNameIdentifierOwner variable;
        if (this.myVarMarker == null) {
            return null;
        }
        if (!this.myVarFile.isValid()) {
            return null;
        }
        PsiElement element = this.myVarFile.getContainingFile().findElementAt(this.myVarMarker.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        if ((variable = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, this.myVariableClass, (boolean)false)) != null) {
            return (V)variable;
        }
        element = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        return (V)((PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, this.myVariableClass, (boolean)false));
    }

    protected void setVariable(V variable) {
        this.myVarFile = variable.getContainingFile();
        this.myVarMarker = this.myEditor.getDocument().createRangeMarker(variable.getTextRange());
    }

    public void setOccurrences(Collection<E> occurrences) {
        this.myOccurrences = (PsiElement[])occurrences.toArray(ArrayUtil.ensureExactSize((int)occurrences.size(), (Object[])this.myOccurrences));
        this.myOccurrenceMarkers = null;
        this.myOccurrencePtrs = new ArrayList<MyPsiPointer>();
        for (PsiElement occurrence : this.getOccurrences()) {
            this.myOccurrencePtrs.add(new MyPsiPointer(occurrence));
        }
        this.initOccurrencesMarkers();
    }

    protected RangeMarker addOccurrence(E occurrence) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(occurrence.getTextRange());
        this.myOccurrences = (PsiElement[])ArrayUtil.append((Object[])this.myOccurrences, occurrence);
        this.myOccurrenceMarkers.add(marker);
        this.myOccurrencePtrs.add(new MyPsiPointer((PsiElement)occurrence));
        return marker;
    }

    protected E getMainExpression() {
        PsiElement mainExpression = this.myOccurrences[0];
        if (mainExpression instanceof OCExpression && !OCElementUtil.isPartOfMacroSubstitution(mainExpression)) {
            return (E)OCParenthesesUtils.diveIntoParentheses((OCExpression)mainExpression);
        }
        return (E)mainExpression;
    }

    protected PsiElement getAnchorParent(PsiElement anchor, boolean isPreview) {
        PsiElement parent = anchor.getParent();
        if (!isPreview && this.myPutToHeaderCb != null && this.myPutToHeaderCb.isSelected() && parent instanceof OCFile) {
            OCFile file2 = (OCFile)parent;
            if (!file2.isHeader()) {
                file2 = file2.getAssociatedFile();
            }
            if (file2 != null && CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file2)) {
                return file2;
            }
        }
        return parent;
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    @Override
    protected void updateTitle(@Nullable V variable, String value) {
        if (variable == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String variableName = variable.getName();
        if (variableName == null) {
            return;
        }
        PsiElement element = this.getPreviewElement(variable);
        int elementOffset = element.getTextRange().getStartOffset();
        TextRange range = this.getMarkupRange(variable);
        String text = this.getVariableTextWithReplacedName(variable, value);
        String varText = null;
        if (range != null) {
            int startOffset = range.getStartOffset() - elementOffset;
            int endOffset = range.getEndOffset() - elementOffset - element.getTextLength() + text.length();
            varText = text.substring(startOffset, endOffset);
            text = text.substring(0, startOffset) + "<var>" + text.substring(endOffset);
        }
        text = this.trimTextForPreview(text);
        if (range != null) {
            this.setPreviewText(text.replaceAll("<var>", varText));
        } else {
            this.setPreviewText(text);
        }
        if (range != null) {
            TextAttributes textAttributes = new TextAttributes();
            textAttributes.setEffectType(EffectType.ROUNDED_BOX);
            textAttributes.setEffectColor((Color)JBColor.RED);
            MarkupModel markupModel = DocumentMarkupModel.forDocument(this.getPreviewEditor().getDocument(), this.myProject, true);
            markupModel.removeAllHighlighters();
            int startPos = text.indexOf("<var>");
            int endPos = startPos + varText.length();
            markupModel.addRangeHighlighter(startPos, endPos, 0, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        this.revalidate();
    }

    protected String getVariableTextWithReplacedName(V variable, String newName) {
        PsiElement element = this.getPreviewElement(variable);
        String text = OCElementUtil.getTextWithMacros(element);
        int offset = variable.getTextOffset() - element.getTextRange().getStartOffset();
        int index = text.indexOf(variable.getName(), offset);
        if (index >= 0) {
            return text.substring(0, index) + newName + text.substring(index + variable.getName().length());
        }
        return text;
    }

    protected String trimTextForPreview(String text) {
        StringBuilder builder = new StringBuilder();
        for (String line : StringUtil.splitByLines((String)text)) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(line.trim());
        }
        return builder.toString();
    }

    @Override
    protected void updateTitle(@Nullable V variable) {
        if (variable != null) {
            this.updateTitle(variable, variable.getName());
        }
    }

    @Nullable
    protected TextRange getMarkupRange(V variable) {
        return null;
    }

    protected PsiElement getPreviewElement(V element) {
        return element;
    }

    @Override
    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        return new LocalSearchScope((PsiElement)this.myElementToRename.getContainingFile());
    }

    @Override
    protected PsiElement checkLocalScope() {
        return this.myElementToRename.getContainingFile();
    }

    @Override
    protected String getActionName() {
        return this.myTitle;
    }

    @Override
    protected V createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        this.myOldDocumentText = this.myEditor.getDocument().getText();
        final String name = this.getInputName() != null ? this.getInputName() : names[0];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                OCBaseInplaceIntroducer.this.introduceForPreview(name);
            }
        });
        this.restoreOccurrences();
        return this.getVariable();
    }

    private static boolean isInvalidOccurrence(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            element = element.getParent();
        }
        return element == null;
    }

    private void restoreOccurrences() {
        for (int i = 0; i < this.myOccurrences.length; ++i) {
            RangeMarker marker = (RangeMarker)this.myOccurrenceMarkers.get(i);
            MyPsiPointer pointer = this.myOccurrencePtrs.get(i);
            PsiElement newElement = OCCodeInsightUtil.findElementAtRange(this.myVarFile, new TextRange(marker.getStartOffset(), marker.getEndOffset()), pointer.getElementClass(), true);
            if (newElement == null || !OCBaseInplaceIntroducer.isInvalidOccurrence(this.myOccurrences[i])) continue;
            this.myOccurrences[i] = newElement;
        }
    }

    @Override
    protected int getCaretOffset() {
        if (this.isPreviewDisabled()) {
            V variable = this.getVariable();
            return variable != null ? variable.getTextOffset() : super.getCaretOffset();
        }
        return super.getCaretOffset();
    }

    @Override
    protected int restoreCaretOffset(int offset) {
        return (offset = super.restoreCaretOffset(offset)) >= this.myEditor.getDocument().getTextLength() ? 0 : offset;
    }

    @Override
    protected void performIntroduce() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().setCurrentCommandName(OCBaseInplaceIntroducer.this.myTitle);
                OCBaseInplaceIntroducer.this.introduceForReal(OCBaseInplaceIntroducer.this.getInputName());
            }
        });
    }

    public void cancelIntroduce() {
        this.releaseResources();
    }

    @Override
    protected void restoreState(@NotNull V psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer", "restoreState"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)OCBaseInplaceIntroducer.this.myProject);
                Document document = OCBaseInplaceIntroducer.this.myEditor.getDocument();
                document.setText((CharSequence)OCBaseInplaceIntroducer.this.myOldDocumentText);
                documentManager.commitDocument(document);
                ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
                for (MyPsiPointer ptr : OCBaseInplaceIntroducer.this.myOccurrencePtrs) {
                    PsiElement occurrence = ptr.getElement();
                    if (occurrence == null) continue;
                    newOccurrences.add(occurrence);
                }
                OCBaseInplaceIntroducer.this.myExpr = OCBaseInplaceIntroducer.this.myExprPtr.getElement();
                OCBaseInplaceIntroducer.this.myExprMarker = OCBaseInplaceIntroducer.this.createMarker(OCBaseInplaceIntroducer.this.myExpr);
                OCBaseInplaceIntroducer.this.setOccurrences(newOccurrences);
            }
        });
    }

    @Override
    public void finish(boolean success) {
        if (!this.myFinished) {
            super.finish(success);
        }
    }

    @Override
    public E restoreExpression(PsiFile containingFile, V variable, RangeMarker marker, String exprText) {
        assert (false);
        return null;
    }

    @Nullable
    protected PsiElement findAnchor(PsiElement parent) {
        PsiElement lastKnownGood = null;
        block0: for (PsiElement statement : parent.getChildren()) {
            for (PsiElement expression : this.myOccurrences) {
                if (expression.isValid() && OCElementUtil.getRangeWithMacros(expression).getStartOffset() < statement.getTextRange().getStartOffset()) break block0;
            }
            lastKnownGood = statement;
        }
        if (lastKnownGood == null) {
            return null;
        }
        PsiElement prevElement = OCElementUtil.getPrevSiblingOrParentSibling(lastKnownGood);
        while (lastKnownGood instanceof OCMacroCall || prevElement instanceof OCMacroCall) {
            lastKnownGood = prevElement;
            prevElement = OCElementUtil.getPrevSiblingOrParentSibling(lastKnownGood);
        }
        return lastKnownGood;
    }

    protected boolean hasNonConstUsages() {
        OCReadWriteAccessDetector detector = new OCReadWriteAccessDetector();
        for (PsiElement occurrence : this.myOccurrences) {
            if (detector.getExpressionAccess(occurrence) == ReadWriteAccessDetector.Access.Read && detector.canBeConstReference(occurrence, false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract String checkExpression(E var1);

    @Nullable
    public abstract PsiElement evaluateAnchor();

    protected abstract void introduceForPreview(String var1);

    protected abstract void introduceForReal(String var1);

    public void setAnchor(PsiElement anchor) {
        this.myAnchorPtr = new MyPsiPointer(anchor);
    }

    @NotNull
    protected PsiElement getAnchor() {
        PsiElement anchor = this.myAnchorPtr.getElement();
        if (anchor == null) {
            anchor = this.evaluateAnchor();
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer", "getAnchor"));
        }
        return psiElement;
    }

    @Nullable
    protected PsiElement getCommonContext() {
        return PsiTreeUtil.findCommonContext((Collection)ContainerUtil.filter((Object[])this.myOccurrences, (Condition)new Condition<E>(){

            public boolean value(E e) {
                return e.isValid();
            }
        }));
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return true;
    }

    @Override
    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    @Override
    protected void saveSettings(@NotNull V variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer", "saveSettings"));
        }
    }

    protected static class MyPsiPointer {
        PsiFile file;
        TextRange range;
        Class<? extends PsiElement> clazz;

        MyPsiPointer(PsiElement element) {
            this.file = element.getContainingFile();
            this.range = OCElementUtil.getRangeWithMacros(element);
            this.clazz = element.getClass();
        }

        Class<? extends PsiElement> getElementClass() {
            return this.clazz;
        }

        @Nullable
        PsiElement getElement() {
            return OCCodeInsightUtil.findElementAtRange(this.file, this.range, this.clazz, true);
        }
    }
}

