/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import java.util.Map;

public class OCInlineConstHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "const";
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof OCDeclarator)) {
            return false;
        }
        OCSymbol symbol = ((OCDeclarator)element).getSymbol();
        return symbol instanceof OCDeclaratorSymbol && symbol.getKind().isGlobalVariable();
    }

    @Override
    protected String checkValidness(OCDeclarator element, List<PsiElement> usages, PsiElement selectedUsage, String elementNameWithKind, Editor editor, Ref<PsiElement> elementData, List<String> warnings, boolean silentMode) {
        if (!((OCDeclaratorSymbol)element.getSymbol()).isConst()) {
            return "Variable \"" + element.getName() + "\" must be const";
        }
        if (element.getInitializer() == null) {
            return StringUtil.capitalize((String)elementNameWithKind) + " must have an initializer";
        }
        return super.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, elementData, warnings, silentMode);
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCExpression initializer = element.getInitializer();
        PsiElement expression = usage.getParent();
        assert (initializer != null);
        if (!(expression instanceof OCReferenceExpression)) {
            return;
        }
        TextRange range = initializer.getTextRange();
        PsiFile fileCopy = (PsiFile)initializer.getContainingFile().copy();
        if ((initializer = (OCExpression)OCCodeInsightUtil.findElementAtRange(fileCopy, range, initializer.getClass(), true)) != null) {
            OCBindUtil.encodeContextInfo(initializer, false);
            PsiElement newInitializer = OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)expression, initializer);
            OCBindUtil.decodeContextInfo(newInitializer, null, elemsToEscalateVisibility);
        }
    }
}

