/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCFunctionUsage
extends OCUsageInfo<OCElement> {
    public OCFunctionUsage(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCFunctionUsage", "<init>"));
        }
        super(reference);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCElement element, @NotNull Project project) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCFunctionUsage", "processUsage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCFunctionUsage", "processUsage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCFunctionUsage", "processUsage"));
        }
        OCElement call = element instanceof OCDeclarator || element instanceof OCConstructorFieldInitializer ? element : (element.getParent() instanceof OCConstructorFieldInitializer ? (OCElement)element.getParent() : (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCCallExpression.class, OCCppNewExpression.class}));
        boolean needReformat = false;
        if (call != null && changeInfo.isParameterSetOrOrderChanged()) {
            if (changeInfo.willBeBlock() || changeInfo.willBeMethod()) {
                assert (call instanceof OCCallExpression);
                PsiElement newCall = OCChangeSignatureUsageProcessor.generateCall(null, ((OCCallExpression)call).getArguments(), changeInfo);
                newCall = OCChangeUtil.replaceHandlingMacros(call, newCall);
                OCImportSymbolFix.fixAllSymbolsRecursively(newCall);
            } else {
                OCChangeSignatureUsageProcessor.changeConstructorOrMethodCall(call, changeInfo);
                needReformat = true;
            }
        } else if (changeInfo.isNameChanged()) {
            if (element instanceof OCReferenceElement) {
                ((OCReferenceElement)element).setName(changeInfo.getNewName());
            } else if (element instanceof OCQualifiedExpression) {
                ((OCQualifiedExpression)element).setName(changeInfo.getNewName());
            }
            needReformat = true;
        }
        if (call != null && needReformat) {
            TextRange range = call.getRangeWithMacros();
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)call.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        }
        return true;
    }
}

