/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCConstructorInEmptyInitializationUsage
extends OCUsageInfo<OCElement> {
    private OCBaseConstructorReference myReference;

    public OCConstructorInEmptyInitializationUsage(@NotNull OCBaseConstructorReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/refactoring/changeSignature/usages/OCConstructorInEmptyInitializationUsage", "<init>"));
        }
        super(reference);
        this.myReference = reference;
    }

    static OCConstructorInitializationList getConstructorInitializationList(OCFunctionDefinition function) {
        OCConstructorInitializationList list = function.getConstructorInitializationList();
        if (list == null) {
            list = function.setConstructorInitializationList(OCElementFactory.constructorInitializationList(function));
        }
        return list;
    }

    @Override
    public boolean processUsage(OCChangeInfo changeInfo, OCElement element, Project project) {
        if (changeInfo.isParameterSetOrOrderChanged()) {
            String text = this.myReference.getField().getSymbol().getName() + "()";
            OCConstructorFieldInitializer initializer = OCElementFactory.constructorFieldInitializerFromText(text, element);
            OCChangeSignatureUsageProcessor.changeConstructorOrMethodCall(initializer, changeInfo);
            if (element instanceof OCFunctionDefinition) {
                OCChangeUtil.add(OCConstructorInEmptyInitializationUsage.getConstructorInitializationList((OCFunctionDefinition)element), initializer);
            } else if (element instanceof OCStruct) {
                List<OCFunctionDeclaration> constructors = ((OCStruct)element).getConstructors();
                if (constructors.size() == 0) {
                    String constructorText = ((OCStruct)element).getName() + "() {}";
                    OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText(constructorText, element);
                    OCChangeUtil.add(element, constructor);
                    OCChangeUtil.add(OCConstructorInEmptyInitializationUsage.getConstructorInitializationList(constructor), initializer);
                } else {
                    OCFunctionDeclaration constructor = constructors.get(0);
                    OCChangeUtil.add(OCConstructorInEmptyInitializationUsage.getConstructorInitializationList((OCFunctionDefinition)constructor), initializer);
                }
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCConstructorInEmptyInitializationUsage that = (OCConstructorInEmptyInitializationUsage)((Object)o);
        OCSymbolDeclarator thisField = this.myReference.getField();
        OCSymbolDeclarator thatField = that.myReference.getField();
        return Comparing.equal(thisField.getSymbol(), thatField.getSymbol());
    }
}

