/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCBlockDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedMethodUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCParameterUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelfSuperUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.refactoring.changeSignature.ChangeSignatureUsageProcessor");
    private static final String BLOCK_CONFLICT = "Can't convert to block: ";

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (!(info instanceof OCChangeInfo)) {
            return UsageInfo.EMPTY_ARRAY;
        }
        return OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, false);
    }

    private static UsageInfo[] findUsages(OCChangeInfo info, boolean onlyCalls) {
        OCCallable method = info.getMethod();
        if (!method.isValid()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        HashSet result2 = new HashSet();
        if (info.getGenerated().getMethodReference() != null) {
            result2.add(new OCGeneratedMethodUsage(info.getGenerated().getMethodReference()));
            if (info.getGenerated().getCallString() != null) {
                result2.add(new OCGeneratedCallUsage(info.getGenerated().getMethodReference()));
            }
        }
        OCChangeSignatureUsageProcessor.findAllMethodUsages(info, method, onlyCalls, (Set<UsageInfo>)result2);
        for (final Pair<Integer, Runnable> pair : info.getGenerated().getCallbacks()) {
            result2.add(new OCUsageInfo<PsiElement>(info.getContext()){

                @Override
                public boolean processUsage(OCChangeInfo changeInfo, PsiElement element, Project project) {
                    ((Runnable)pair.getSecond()).run();
                    return true;
                }

                @Override
                public int getUsageRank() {
                    return (Integer)pair.getFirst();
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object o) {
                    return this == o;
                }
            });
        }
        return result2.toArray(new UsageInfo[result2.size()]);
    }

    private static void findAllMethodUsages(final @Nullable OCChangeInfo info, final OCCallable method, final boolean onlyCalls, final Set<UsageInfo> result2) {
        OCChangeSignatureUsageProcessor.findOneMethodUsages(method, info, result2, onlyCalls, false);
        if (method instanceof OCBlockExpression || !info.isChangeUsages()) {
            return;
        }
        OCSearchUtil.processMembersHierarchyPsi((OCSymbolWithParent)method.getSymbol(), new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof OCCallable && !Comparing.equal((Object)element, (Object)method)) {
                    OCChangeSignatureUsageProcessor.findOneMethodUsages((OCCallable)element, info, result2, onlyCalls, true);
                }
                return true;
            }
        }, info.isChangeAncestors(), true);
    }

    private static void findOneMethodUsages(OCCallable method, OCChangeInfo info, Set<UsageInfo> result2, boolean onlyCalls, boolean isInherited) {
        List<PsiNamedElement> parameters;
        if (info.isChangeUsages()) {
            OCSearchUtil.findOneMethodUsages(method, result2);
            String oldName = info.getMethod().getName();
            if (oldName != null && !oldName.isEmpty()) {
                TextOccurrencesUtil.findNonCodeUsages(method, oldName, true, true, info.getNewName(), result2);
            }
        }
        if (onlyCalls) {
            return;
        }
        if (info.getGenerated().getMethodReference() == null) {
            if (method instanceof OCFunctionDeclaration) {
                result2.add(new OCFunctionDefinitionUsage((OCFunctionDeclaration)method, isInherited));
            } else if (method instanceof OCBlockExpression) {
                result2.add(new OCBlockDefinitionUsage((OCBlockExpression)method));
            } else if (method instanceof OCMethod) {
                result2.add(new OCMethodDefinitionUsage((OCMethod)method, isInherited));
            }
        }
        if ((parameters = method.getParameters()) == null) {
            return;
        }
        for (OCParameterInfo newParam : info.getNewParameters()) {
            PsiNamedElement oldParam;
            if (newParam.getUsages() != null) {
                for (PsiReference usage : newParam.getUsages()) {
                    result2.add(new OCParameterUsage(usage, newParam, method, isInherited));
                }
            }
            if (newParam.getOldIndex() < 0 || newParam.getOldIndex() >= parameters.size() || Comparing.equal((String)(oldParam = parameters.get(newParam.getOldIndex())).getName(), (String)newParam.getName())) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                result2.add(new OCParameterUsage(ref, newParam, method, isInherited));
            }
        }
        for (OCReferenceExpression expr : info.getOldMethodDescriptor().getSelfReferences()) {
            if (!expr.isValid()) continue;
            result2.add(new OCSelfSuperUsage(expr));
        }
    }

    public static boolean canProceedWithConflict(String conflict) {
        return !conflict.startsWith(BLOCK_CONFLICT);
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages;
        if (!(info instanceof OCChangeInfo)) {
            return MultiMap.EMPTY;
        }
        final MultiMap result2 = new MultiMap();
        final PsiElement method = info.getMethod();
        final OCChangeInfo changeInfo = (OCChangeInfo)info;
        final String fullNewName = (Object)((Object)changeInfo.getNewCallableKind()) + " '" + changeInfo.getNewName() + "'";
        if (!changeInfo.willBeMethod()) {
            for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                PsiElement element = usage.getElement();
                if (!(element instanceof OCSelectorExpression)) continue;
                result2.putValue((Object)usage.getElement(), (Object)"Can't convert selector expression to function/block");
            }
            usages = OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, true);
            if (changeInfo.willBeBlock() && !(changeInfo.getMethod() instanceof OCBlockExpression) && changeInfo.getGenerated().getMethodReference() == null) {
                for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                    PsiElement psiElement = usage.getElement();
                    if (psiElement == null || ((Object)((Object)OCLanguage.getInstance())).equals(psiElement.getLanguage())) continue;
                    result2.putValue((Object)usage.getElement(), (Object)("Can't convert usage in " + psiElement.getLanguage().getDisplayName() + " code"));
                }
                if (usages.length == 0) {
                    result2.putValue((Object)method, (Object)"Can't convert to block: no usages is found");
                } else if (usages.length > 1) {
                    result2.putValue((Object)method, (Object)"Can't convert to block: more than 1 usage is found");
                } else if (PsiTreeUtil.isAncestor((PsiElement)changeInfo.getMethod(), (PsiElement)usages[0].getElement(), (boolean)true)) {
                    result2.putValue((Object)method, (Object)"Can't convert to block: usage is inside the function/method");
                }
            }
        }
        if (changeInfo.willBeFunction()) {
            OCQualifiedName name;
            OCSymbolWithQualifiedName originalSymbol;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = originalSymbol = method instanceof OCFunctionDeclaration ? (OCSymbolWithQualifiedName)((OCFunctionDeclaration)method).getSymbol() : null;
            final OCQualifiedName parentName = originalSymbol != null ? ((name = originalSymbol.getResolvedQualifiedName()) != null ? name.getQualifier() : OCQualifiedName.GLOBAL) : OCQualifiedName.GLOBAL;
            List parameterTypes = ContainerUtil.map((Object[])changeInfo.getNewParameters(), (Function)new Function<OCParameterInfo, OCType>(){

                public OCType fun(OCParameterInfo info) {
                    OCType result2 = info.getType();
                    return result2 != null ? result2.resolve(changeInfo.getContext().getContainingFile()) : OCUnknownType.INSTANCE;
                }
            });
            final OCFunctionType functionType = new OCFunctionType(OCVoidType.instance(), parameterTypes);
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(method.getProject(), new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    boolean conflict = false;
                    if (symbol instanceof OCSymbolWithQualifiedName && (!symbol.isSameSymbol(originalSymbol) || !method.isPhysical()) && OCResolveUtil.isDuplicate(OCSymbolKind.FUNCTION_DECLARATION, symbol.getKind())) {
                        OCQualifiedName name = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                        if (name != null && Comparing.equal((Object)parentName, (Object)name.getQualifier())) {
                            if (symbol instanceof OCFunctionSymbol && (((OCFile)method.getContainingFile()).isCpp() || symbol.getAttributes().contains("overloadable"))) {
                                OCType type = symbol.getResolvedType();
                                OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(type, false, new OCResolveContext(method));
                                if (type instanceof OCFunctionType && visitor.isFunctionSignatureEqual(functionType)) {
                                    conflict = true;
                                }
                            } else {
                                conflict = true;
                            }
                        }
                        if (conflict) {
                            String kind = symbol.getKindLowercase();
                            OCQualifiedName symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                            if (symbolName != null) {
                                String qualifiedName = symbolName.dropSuperQualifier().toString();
                                result2.putValue((Object)method, (Object)(fullNewName + " will conflict with " + kind + " " + qualifiedName + (symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getParamsSignatureWithoutNames() : "")));
                            }
                        }
                    }
                    return true;
                }
            }, info.getNewName());
        } else if (changeInfo.willBeMethod()) {
            OCClassSymbol generatedParent;
            OCClassDeclaration parentClass;
            usages = (UsageInfo[])refUsages.get();
            int numOfFunctions = 0;
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                ++numOfFunctions;
            }
            if (numOfFunctions > 1) {
                for (UsageInfo usageInfo : usages) {
                    if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                    result2.putValue((Object)usageInfo.getElement(), (Object)("Function '" + changeInfo.getNewName() + "' has several definitions"));
                }
            }
            if ((parentClass = OCElementUtil.resolveClassDeclaration(generatedParent = (OCClassSymbol)changeInfo.getGenerated().getMethodParent())) == null) {
                parentClass = changeInfo.getNewContainerClass();
            }
            if (parentClass != null && (changeInfo.isNameChanged() || generatedParent != null)) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(changeInfo.getNewName(), parentClass.getSymbol(), method.getProject(), OCMethodSymbol.class, changeInfo.getMethod() instanceof OCMethod && ((OCMethod)changeInfo.getMethod()).isInstanceMethod() ? OCObjectTypeContext.StaticMode.INSTANCE : OCObjectTypeContext.StaticMode.STATIC);
                parameters.setIncludeSelfImplementation(true);
                parameters.setAncestors(true);
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol methodSymbol) {
                        result2.putValue((Object)method, (Object)(fullNewName + " will conflict with method in " + ((OCClassSymbol)methodSymbol.getParent()).getNameWithKindLowercase()));
                        return true;
                    }
                });
            }
        }
        OCBlockStatement body = ((OCCallable)info.getMethod()).getBody();
        HashSet set = new HashSet();
        for (ParameterInfo parameterInfo : info.getNewParameters()) {
            if (parameterInfo.getName().isEmpty() || set.add(parameterInfo.getName())) continue;
            result2.putValue((Object)method, (Object)("At least two parameters have the name '" + parameterInfo.getName() + "'"));
        }
        if (body != null) {
            for (ParameterInfo parameterInfo : info.getNewParameters()) {
                OCResolveUtil.processLocalSymbols(parameterInfo.getName(), body.getClosingBrace(), new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        if (symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE) {
                            result2.putValue((Object)method, (Object)(symbol.getNameWithKindUppercase() + " conflicts with new parameter"));
                        }
                        return true;
                    }
                });
            }
        }
        for (ParameterInfo parameterInfo : (UsageInfo[])refUsages.get()) {
            PsiElement element;
            if (parameterInfo instanceof OCSelectorExpressionUsage) {
                element = parameterInfo.getElement();
                if (!(element instanceof OCSelectorExpression) || OCSelectorAdHocResolver.getActionTargetContext((OCExpression)element) != null) continue;
                result2.putValue((Object)element, (Object)"Possibly unrelated selector with the same name will be renamed");
                continue;
            }
            if (!(parameterInfo instanceof OCMethodCallUsage) || !((element = parameterInfo.getElement()) instanceof OCSendMessageExpression) || ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder() != null) continue;
            result2.putValue((Object)element, (Object)"Possibly unrelated selector with the same name will be renamed");
        }
        return result2;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!(usageInfo instanceof OCUsageInfo)) {
            return false;
        }
        if (beforeMethodChange) {
            return true;
        }
        Project project = changeInfo.getMethod().getProject();
        PsiElement element = usageInfo.getElement();
        return ((OCUsageInfo)usageInfo).processUsage((OCChangeInfo)changeInfo, element, project);
    }

    public static void processParameters(OCChangeInfo changeInfo, OCCallable function, OCParameterList parameters, Project project, boolean isInherited) {
        int paramIndex = 0;
        if (parameters != null) {
            OCParameterInfo[] newParameters = changeInfo.getNewParameters();
            for (OCParameterDeclaration parameter : parameters.getParameterDeclarations()) {
                OCSymbol symbol;
                String oldTypeText;
                OCTypeElement typeElement = parameter.getTypeElement();
                if (paramIndex >= newParameters.length) {
                    if (paramIndex == 0 && newParameters.length == 0 && typeElement != null && typeElement.getType().isVoid()) break;
                    LOG.error("Invalid parameter is involved into rename procedure!");
                    break;
                }
                OCDeclarator declarator = parameter.getDeclarator();
                PsiElement identifier = declarator != null ? declarator.getNameIdentifier() : null;
                OCParameterInfo parameterInfo = newParameters[paramIndex];
                if (identifier != null) {
                    OCElementUtil.replaceWithIdentifier(identifier, changeInfo.getNewParameterName(isInherited, function, parameterInfo), identifier);
                }
                if (typeElement != null && declarator != null && parameterInfo.isTypeChanged(oldTypeText = declarator.getType().getBestNameInContext(declarator, OCElementUtil.getTypeTextWithModifiers(parameter))) && (symbol = declarator.getSymbol()) != null) {
                    new OCChangeTypeIntentionAction(symbol, parameterInfo.getType()).invoke(project, null, declarator.getContainingFile());
                }
                ++paramIndex;
            }
        }
    }

    public static void changeConstructorOrMethodCall(@Nullable OCElement callExpression, OCChangeInfo changeInfo) {
        int paramIndex = 0;
        PsiElement name = null;
        OCArgumentList oldArguments = null;
        if (callExpression instanceof OCCppNewExpression) {
            oldArguments = ((OCCppNewExpression)callExpression).getArgumentList();
        } else if (callExpression instanceof OCDeclarator) {
            oldArguments = (OCArgumentList)PsiTreeUtil.getChildOfType((PsiElement)callExpression, OCArgumentList.class);
            if (oldArguments == null) {
                OCCallExpression emptyCall = OCElementFactory.callExpression(changeInfo.getNewName(), Collections.<String>emptyList(), changeInfo.getContext());
                oldArguments = (OCArgumentList)callExpression.add(emptyCall.getArgumentList());
            }
        } else if (callExpression instanceof OCConstructorFieldInitializer) {
            oldArguments = ((OCConstructorFieldInitializer)callExpression).getArgumentList();
        } else if (callExpression instanceof OCCallExpression) {
            oldArguments = ((OCCallExpression)callExpression).getArgumentList();
            OCExpression function = ((OCCallExpression)callExpression).getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                name = referenceElement != null ? referenceElement.getNameIdentifier() : null;
            } else if (function instanceof OCQualifiedExpression) {
                name = ((OCQualifiedExpression)function).getSelectorElement();
            }
        }
        ArrayList<String> paramStubs = new ArrayList<String>();
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(false, false));
        }
        OCCallExpression stubCall = OCElementFactory.callExpression(changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        if (oldArguments != null) {
            for (OCExpression argument : stubCall.getArguments()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldArguments.getArguments().size()) continue;
                OCChangeUtil.replaceHandlingMacros(argument, oldArguments.getArguments().get(parameterInfo.getOldIndex()));
            }
            oldArguments = (OCArgumentList)OCChangeUtil.replaceHandlingMacros(oldArguments, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        } else if (callExpression instanceof OCCppNewExpression) {
            oldArguments = OCChangeUtil.add(callExpression, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        }
        if (name != null && changeInfo.isNameChanged()) {
            OCElementUtil.replaceWithIdentifier(name, changeInfo.getNewName(), stubCall);
        }
    }

    public static PsiElement generateCall(@Nullable OCExpression receiver, List<OCExpression> arguments, OCChangeInfo changeInfo) {
        OCCallable block;
        int paramIndex;
        ArrayList<String> paramStubs = new ArrayList<String>();
        OCCallable parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)receiver, OCCallable.class);
        boolean isSelfSuperCall = changeInfo.getMethod().equals(parentCallable) || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && parentCallable instanceof OCMethod && Comparing.equal((String)changeInfo.getMethod().getName(), (String)parentCallable.getName());
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(changeInfo.willBeMethod(), isSelfSuperCall));
        }
        if (changeInfo.willBeMethod()) {
            OCSendMessageExpression sendMessageExpression = OCElementFactory.sendMessageExpression(paramStubs, changeInfo.getContext());
            paramIndex = 0;
            for (OCExpression stubArgument : sendMessageExpression.getArgumentExpressions()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
                OCExpression newArgument = arguments.get(parameterInfo.getOldIndex());
                OCChangeUtil.replaceHandlingMacros(stubArgument, newArgument);
            }
            if (changeInfo.getOldMethodDescriptor().getCallableKind() != OCCallableKind.METHOD) {
                receiver = OCElementFactory.expressionFromText(changeInfo.getNewContainerClass().getName(), changeInfo.getContext());
            }
            OCChangeUtil.replaceHandlingMacros(sendMessageExpression.getReceiverExpression(), receiver);
            return sendMessageExpression;
        }
        OCCallExpression callExpression = OCElementFactory.callExpression(changeInfo.willBeBlock() ? "block" : changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        paramIndex = 0;
        for (OCExpression argument : callExpression.getArguments()) {
            OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
            OCExpression oldArgument = arguments.get(parameterInfo.getOldIndex());
            OCChangeUtil.replaceHandlingMacros(argument, oldArgument);
        }
        if (changeInfo.willBeBlock() && (block = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false)) != null) {
            OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), block);
            changeInfo.setNewMethod(block);
        }
        return callExpression;
    }

    @Nullable
    public static OCCallable generateMethodDefinition(OCChangeInfo changeInfo, OCCallable oldMethod, boolean needBody, boolean needComments, boolean isInherited) {
        String newSignature;
        OCCallable<OCMethodSymbol> result2 = null;
        OCBlockStatement body = oldMethod.getBody();
        PsiFile context = oldMethod.getContainingFile();
        String string = newSignature = isInherited ? changeInfo.getNewInheritedSignature(oldMethod) : changeInfo.getNewSignature();
        if (changeInfo.willBeMethod()) {
            result2 = OCElementFactory.methodFromSignature(newSignature, (PsiElement)context, needBody && (body != null || oldMethod instanceof OCFunctionDeclaration), false);
        } else if (changeInfo.willBeFunction()) {
            OCMethodDescriptor methodDescriptor = changeInfo.getOldMethodDescriptor();
            OCDeclaration declaration = methodDescriptor.isConstructor() ? OCElementFactory.constructorFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context) : OCElementFactory.declarationFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context);
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            result2 = (OCCallable)((Object)declaration);
        } else if (changeInfo.willBeBlock()) {
            result2 = body != null ? (OCBlockExpression)OCElementFactory.expressionFromText(newSignature + "{\n}", (PsiElement)context) : null;
        } else assert (false);
        if (needBody && body != null && result2 != null && body.isValid()) {
            OCChangeUtil.replaceHandlingMacros(result2.getBody(), body);
        }
        OCElementUtil.replaceDeclarationQualifiers(result2, oldMethod);
        if (needComments) {
            OCElementUtil.replaceComments(result2, oldMethod);
        }
        if (result2 != null && changeInfo.getContext() != null) {
            OCElementFactory.initIndentFromContext(changeInfo.getContext(), result2);
        }
        return result2;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        return changeInfo instanceof OCChangeInfo;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSnapshotProvider", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureUsageProcessor", "registerConflictResolvers"));
        }
    }
}

