/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureDialog;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureActionHandler
implements ChangeSignatureHandler {
    public static final DataKey<OCCallableKind> CALLABLE_KIND = DataKey.create((String)"callable_kind");
    private static final String TARGET_NOT_FOUND_MESSAGE = "The caret should be positioned at the method, function or block";

    public PsiElement findTargetMember(PsiFile file2, Editor editor) {
        return this.findTargetMember(file2.findElementAt(editor.getCaretModel().getOffset()));
    }

    public PsiElement findTargetMember(PsiElement element) {
        OCElement context = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class, OCCppNewExpression.class, OCConstructorFieldInitializer.class, OCCallExpression.class, OCSendMessageExpression.class, OCSelectorExpression.class});
        if (context instanceof OCCallExpression) {
            PsiReference reference;
            OCExpression function = ((OCCallExpression)context).getFunctionReferenceExpression();
            PsiElement declarator = null;
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                declarator = referenceElement != null ? referenceElement.resolve() : null;
            } else if (function instanceof OCQualifiedExpression && (reference = function.getReference()) != null) {
                declarator = reference.resolve();
            }
            if (declarator != null && declarator.getContext() instanceof OCFunctionDeclaration) {
                return OCChangeSignatureActionHandler.checkKRFunction(declarator.getContext()) ? null : declarator.getContext();
            }
            return null;
        }
        if (context instanceof OCCppNewExpression || context instanceof OCConstructorFieldInitializer) {
            PsiElement constructor;
            OCReferenceElement reference = context instanceof OCCppNewExpression ? ((OCCppNewExpression)context).getReferenceElement() : ((OCConstructorFieldInitializer)context).getReferenceElement();
            if (reference != null && (constructor = reference.resolve()) != null && constructor.getContext() instanceof OCFunctionDeclaration) {
                return constructor.getContext();
            }
            return null;
        }
        if (context instanceof OCSendMessageExpression || context instanceof OCSelectorExpression) {
            OCPolyVariantReference reference = (OCPolyVariantReference)context.getReference();
            if (reference == null) {
                return null;
            }
            List symbols = reference.resolveToSymbols();
            if (symbols.size() == 0) {
                return null;
            }
            return ((OCMethodSymbol)symbols.iterator().next()).locateDefinition();
        }
        if (context instanceof OCCallable) {
            OCBlockStatement body = ((OCCallable)context).getBody();
            if (body == null || !body.getTextRange().contains(element.getTextOffset())) {
                return OCChangeSignatureActionHandler.checkKRFunction(context) ? null : context;
            }
            return null;
        }
        return null;
    }

    private static boolean checkKRFunction(PsiElement declarator) {
        ASTNode declaration = declarator.getNode();
        return declaration.getElementType() == OCElementTypes.FUNCTION_KR_DEFINITION;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureActionHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        OCChangeSignatureActionHandler.invoke(project, editor, this.findTargetMember(file2, editor), dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureActionHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureActionHandler", "invoke"));
        }
        OCChangeSignatureActionHandler.invoke(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), elements[0], dataContext);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return TARGET_NOT_FOUND_MESSAGE;
    }

    private static void invoke(Project project, Editor editor, PsiElement element, DataContext dataContext) {
        if (!(element instanceof OCCallable)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)TARGET_NOT_FOUND_MESSAGE, (String)REFACTORING_NAME, null);
            return;
        }
        if (!OCCodeInsightUtil.isValid(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)REFACTORING_NAME, null);
            return;
        }
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)element, true);
        if (OCChangeSignatureActionHandler.checkVariableArguments(project, editor, handler2)) {
            return;
        }
        OCCallableKind callableKind = (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext));
        if (callableKind != null) {
            if (((OCCallable)element).getBody() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Select the implementation to convert to " + (Object)((Object)callableKind)), (String)REFACTORING_NAME, null);
                return;
            }
            handler2.setCallableKind(callableKind);
        }
        handler2.invoke();
    }

    public static boolean checkVariableArguments(Project project, Editor editor, OCChangeSignatureHandler handler2) {
        OCMethodDescriptor methodDescriptor = handler2.getMethodDescriptor();
        if (methodDescriptor == null) {
            return false;
        }
        OCSymbol symbol = methodDescriptor.getMethodSymbol();
        if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isVararg() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isVararg()) {
            String message = "Can't refactor a " + symbol.getKind().getNameLowercase() + " with variable arguments";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            return true;
        }
        return false;
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, boolean isChangeCallableKindPossible) {
        return OCChangeSignatureActionHandler.getHandler(callable, callable, isChangeCallableKindPossible, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, silentMode);
    }

    private static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, isChangeCallableKindPossible, silentMode, !silentMode, false);
    }

    public static OCChangeSignatureHandler getHandler(OCCallable callable, PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode, boolean askForSuperMethods, boolean sureThatConstructor) {
        OCSearchUtil.Ancestor ancestor;
        OCSymbol symbol = callable.getSymbol();
        Project project = callable.getProject();
        boolean refactorAncestors = false;
        if (symbol instanceof OCSymbolWithParent && (ancestor = OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol)) != null) {
            String subject = symbol.getKind().getNameLowercase();
            String message = symbol.getNameWithKindUppercase() + " overrides " + subject + " in " + ancestor.getSymbol().getParent().getNameWithKindLowercase() + (ancestor.isOutOfProject() ? " which is out of project" : "");
            if (ancestor.isOutOfProject()) {
                int result2;
                if (askForSuperMethods && (result2 = Messages.showYesNoDialog((Project)project, (String)(message + ". Do you want to proceed the refactoring?"), (String)"Warning", (Icon)Messages.getQuestionIcon())) != 0) {
                    return OCEmptyChangeSignatureHandler.INSTANCE;
                }
            } else {
                int result3;
                if (askForSuperMethods) {
                    result3 = Messages.showYesNoCancelDialog((Project)project, (String)(message + ". Do you want to refactor the base " + subject + "s?"), (String)"Warning", (Icon)Messages.getQuestionIcon());
                } else {
                    int n = result3 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 1;
                }
                if (result3 == 0) {
                    refactorAncestors = true;
                } else if (result3 != 1) {
                    return OCEmptyChangeSignatureHandler.INSTANCE;
                }
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)callable) || context == null) {
            return OCEmptyChangeSignatureHandler.INSTANCE;
        }
        if (!callable.getContainingOCFile().getKind().isObjC()) {
            isChangeCallableKindPossible = false;
        }
        OCMethodDescriptor methodDescriptor = OCMethodDescriptor.createMethodDescriptor(callable);
        methodDescriptor.setChangeCallableKindPossible(isChangeCallableKindPossible);
        methodDescriptor.setSureIsConstructor(sureThatConstructor);
        OCChangeSignatureHandlerImpl handler2 = silentMode ? new OCChangeSignatureHandlerImpl(methodDescriptor, context) : new OCChangeSignatureDialog(project, methodDescriptor, context).getHandler();
        handler2.setChangeAncestors(refactorAncestors);
        return handler2;
    }
}

