/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNameSuggester {
    public static final String BOOLEAN_SHORT_NAME = "b";
    public static final String INT_SHORT_NAME = "i";
    public static final String DOUBLE_SHORT_NAME = "d";
    public static final String STRING_SHORT_NAME = "string";
    public static final String AUTO_SHORT_NAME = "item";
    public static final String POINTER_SHORT_NAME = "ptr";
    public static final String OBJECT_SHORT_NAME = "o";
    public static final String FUNCTION_SHORT_NAME = "fun";
    public static final String VOID_SHORT_NAME = "v";
    public static final String BOOLEAN_LONG_NAME = "boolean";
    public static final String INT_LONG_NAME = "int";
    public static final String DOUBLE_LONG_NAME = "double";
    public static final String OBJECT_LONG_NAME = "object";
    public static final String FUNCTION_LONG_NAME = "function";
    public static final String VOID_LONG_NAME = "void";
    private static String[] GARBAGE_SUFFIXES = new String[]{"Impl", "IMPL", "Ref", "REF"};
    private static String[] SHORT_NAMES = new String[]{"b", "i", "d", "string", "ptr", "o", "fun", "v", "item"};

    private OCNameSuggester() {
    }

    public static Collection<String> suggestForDeclaration(OCDeclarator subj, boolean unique, @NotNull Collection<String> predefinedNames) {
        if (predefinedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedNames", "com/jetbrains/cidr/lang/refactoring/OCNameSuggester", "suggestForDeclaration"));
        }
        HashSet whiteList = ContainerUtil.newHashSet(predefinedNames);
        HashSet blackList = ContainerUtil.newHashSet();
        Ref symbolKindRef = new Ref();
        Collection<String> candidates = OCNameSuggester.doSuggestForDeclaration(subj, (Ref<OCSymbolKind>)symbolKindRef, whiteList, blackList);
        HashSet result2 = ContainerUtil.newHashSet(candidates);
        if (unique) {
            blackList.removeAll(whiteList);
            result2.retainAll(whiteList);
            HashSet toProcess = ContainerUtil.newHashSet(candidates);
            toProcess.removeAll(whiteList);
            result2.addAll(OCNameSuggester.convertToUniqueNames((OCSymbolKind)((Object)symbolKindRef.get()), toProcess, subj, blackList));
        }
        return result2;
    }

    private static Collection<String> doSuggestForDeclaration(OCDeclarator subj, Ref<OCSymbolKind> symbolKindRef, Collection<String> whiteList, Collection<String> blackList) {
        Object classSymbol;
        PsiElement ifs;
        if (subj.getParent() instanceof OCDeclaration && ((OCDeclaration)subj.getParent()).isTypedef()) {
            return Collections.emptyList();
        }
        OCExpression initializer = subj.getInitializer();
        if (initializer != null) {
            return OCNameSuggester.doSuggestForExpression(initializer);
        }
        PsiElement declContext = subj.getContext();
        if (declContext != null && (declContext = declContext.getContext()) instanceof OCDeclarationStatement) {
            declContext = declContext.getContext();
        }
        if (declContext instanceof OCForeachStatement) {
            OCExpression collectionExpression = ((OCForeachStatement)declContext).getCollectionExpression();
            LinkedHashSet<String> candidates = new LinkedHashSet<String>();
            for (String collectionSuggestion : OCNameSuggester.doSuggestionForContext(collectionExpression)) {
                String unplured = StringUtil.unpluralize((String)collectionSuggestion);
                candidates.add(unplured != null ? unplured : collectionSuggestion);
            }
            candidates.addAll(OCNameSuggester.doSuggestForType(subj.getType(), "", collectionExpression));
            return candidates;
        }
        if (declContext instanceof OCProperty) {
            Object classSymbol2;
            PsiElement ifs2 = declContext.getParent();
            if (ifs2 instanceof OCSymbolDeclarator && (classSymbol2 = ((OCSymbolDeclarator)ifs2).getSymbol()) instanceof OCClassSymbol) {
                symbolKindRef.set((Object)OCSymbolKind.PROPERTY);
                return OCNameSuggester.suggestForProperty(subj, (OCClassSymbol)classSymbol2, whiteList, blackList);
            }
        } else if (declContext instanceof OCInstanceVariablesList && (ifs = declContext.getParent()) instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
            symbolKindRef.set((Object)OCSymbolKind.INSTANCE_VARIABLE);
            return OCNameSuggester.suggestForIvar(subj, (OCClassSymbol)classSymbol, blackList);
        }
        return OCNameSuggester.doSuggestForType(subj.getType(), "", declContext);
    }

    private static Collection<String> suggestForIvar(final OCDeclarator declarator, OCClassSymbol classSymbol, Collection<String> forbiddenNames) {
        THashSet names = new THashSet();
        OCInterfaceSymbol mi = classSymbol.getMainInterface();
        final String auxCategoryName = classSymbol instanceof OCInterfaceSymbol ? classSymbol.getCategoryName() : "";
        final OCClassSymbol mainInterface = mi == null ? classSymbol : mi;
        Processor<OCPropertySymbol> propertyProcessor = new Processor<OCPropertySymbol>((Set)names){
            final /* synthetic */ Set val$names;
            {
                this.val$names = set;
            }

            public boolean process(OCPropertySymbol propertySymbol) {
                OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar();
                if (propertySymbol.getType().isCompatible(declarator.getType(), declarator) && (ivar == null || ivar.getGeneratedFromProperty() != null)) {
                    this.val$names.add(OCNameSuggester.getNonCollidingName(propertySymbol, true));
                }
                return true;
            }
        };
        Processor<OCSymbol> iVarProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        mainInterface.processCategories((Processor<? super OCClassSymbol>)new Processor<OCClassSymbol>((Processor)propertyProcessor, iVarProcessor){
            final /* synthetic */ Processor val$propertyProcessor;
            final /* synthetic */ Processor val$iVarProcessor;
            {
                this.val$propertyProcessor = processor2;
                this.val$iVarProcessor = processor3;
            }

            public boolean process(OCClassSymbol ifs) {
                if (StringUtil.compare((String)ifs.getCategoryName(), (String)auxCategoryName, (boolean)false) == 0 || ifs == mainInterface) {
                    ifs.processMembers(OCPropertySymbol.class, this.val$propertyProcessor);
                    ifs.processMembers(OCInstanceVariableSymbol.class, this.val$iVarProcessor);
                }
                return true;
            }
        }, true, null);
        for (String name : OCNameSuggester.doSuggestForType(declarator.getType(), "", declarator)) {
            names.add(OCNameSuggester.getNonCollidingName(name, OCSymbolKind.PROPERTY, true, declarator.getProject()));
        }
        return names;
    }

    private static Collection<String> suggestForProperty(final @NotNull OCDeclarator declarator, @NotNull OCClassSymbol interfaceSymbol, Collection<String> whiteList, Collection<String> forbiddenNames) {
        OCImplementationSymbol implementation;
        if (declarator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarator", "com/jetbrains/cidr/lang/refactoring/OCNameSuggester", "suggestForProperty"));
        }
        if (interfaceSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceSymbol", "com/jetbrains/cidr/lang/refactoring/OCNameSuggester", "suggestForProperty"));
        }
        THashSet names = new THashSet();
        Processor<OCInstanceVariableSymbol> ivarProcessor = new Processor<OCInstanceVariableSymbol>((Set)names, whiteList){
            final /* synthetic */ Set val$names;
            final /* synthetic */ Collection val$whiteList;
            {
                this.val$names = set;
                this.val$whiteList = collection;
            }

            public boolean process(OCInstanceVariableSymbol ivar) {
                if (!OCResolveUtil.isDisabledSymbol(ivar, declarator.getContainingFile()) && ivar.getAssociatedProperty() == null && declarator.getType().isCompatible(ivar.getType(), declarator)) {
                    String name = OCNameSuggester.getNonCollidingName(ivar, true);
                    this.val$names.add(name);
                    this.val$whiteList.add(name);
                }
                return true;
            }
        };
        Processor<OCSymbol> propertyProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        interfaceSymbol.processCategories((Processor<? super OCClassSymbol>)new Processor<OCClassSymbol>((Processor)ivarProcessor, propertyProcessor){
            final /* synthetic */ Processor val$ivarProcessor;
            final /* synthetic */ Processor val$propertyProcessor;
            {
                this.val$ivarProcessor = processor2;
                this.val$propertyProcessor = processor3;
            }

            public boolean process(OCClassSymbol interfaceSymbol) {
                String category = interfaceSymbol.getCategoryName();
                if (category == null || category.isEmpty()) {
                    interfaceSymbol.processMembers(OCInstanceVariableSymbol.class, this.val$ivarProcessor);
                    interfaceSymbol.processMembers(OCPropertySymbol.class, this.val$propertyProcessor);
                }
                return true;
            }
        }, true, null);
        String categoryName = interfaceSymbol.getCategoryName();
        if ((categoryName == null || categoryName.isEmpty()) && (implementation = interfaceSymbol.getMainImplementation()) != null) {
            implementation.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
        }
        names.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), "", declarator));
        return names;
    }

    private static Processor<OCSymbol> namesCollectProcessor(final Collection<String> names, final OCElement excludedElement) {
        return new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                Object ivarDecl = symbol.locateDefinition();
                if (ivarDecl != null && ivarDecl.getTextOffset() != excludedElement.getTextOffset()) {
                    names.add(symbol.getName());
                }
                return true;
            }
        };
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, OCExpression expr) {
        final ArrayList<String> forbiddenNames = new ArrayList<String>();
        expr.accept(new OCRecursiveVisitor(){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                if (referenceElement.resolveToSymbol() != null) {
                    forbiddenNames.add(referenceElement.getName());
                }
            }
        });
        return OCNameSuggester.convertToUniqueNames(symbolKind, OCNameSuggester.doSuggestForExpression(expr), expr, forbiddenNames);
    }

    private static Collection<String> doSuggestForExpression(OCExpression expr) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        OCExpression topmost = OCParenthesesUtils.topmostParenthesized(expr);
        answer.addAll(OCNameSuggester.doSuggestForExpressionContext(topmost, topmost.getParent()));
        answer.addAll(OCNameSuggester.doSuggestForType(expr.getType().getGuessedType(), "", expr));
        answer.addAll(OCNameSuggester.doSuggestionForContext(OCParenthesesUtils.diveIntoParentheses(expr)));
        return answer;
    }

    private static List<String> doSuggestForExpressionContext(OCExpression expr, PsiElement context) {
        List<OCDeclaratorSymbol> symbols;
        OCSymbol fun;
        int index;
        PsiElement arglistParent;
        if (context instanceof OCMessageArgument) {
            OCMethodSymbol.SelectorPartSymbol selector;
            OCDeclaratorSymbol parameter;
            List<OCMethodSymbol.SelectorPartSymbol> selectors;
            OCMethodSymbol responder;
            OCSendMessageExpression call = (OCSendMessageExpression)context.getParent();
            int index2 = call.getArguments().indexOf(context);
            if (index2 >= 0 && (responder = call.getProbableResponders().getKnownResponder()) != null && index2 < (selectors = responder.getSelectors()).size() && (parameter = (selector = selectors.get(index2)).getParameter()) != null) {
                return OCNameSuggester.doGetSuggestionsByName(parameter.getName(), "");
            }
        } else if (context instanceof OCArgumentList && (arglistParent = context.getParent()) instanceof OCCallExpression && (index = ((OCCallExpression)arglistParent).getArguments().indexOf(expr)) >= 0 && (fun = OCLValueVisitor.getSymbol(((OCCallExpression)arglistParent).getFunctionReferenceExpression())) instanceof OCFunctionSymbol && index < (symbols = ((OCFunctionSymbol)fun).getParameterSymbols()).size()) {
            return OCNameSuggester.doGetSuggestionsByName(symbols.get(index).getName(), "");
        }
        return Collections.emptyList();
    }

    private static List<String> doSuggestionForContext(@Nullable OCExpression expr) {
        if (expr instanceof OCReferenceExpression && ((OCReferenceExpression)expr).getSelfSuperToken() == null) {
            return OCNameSuggester.doGetSuggestionsByName(expr.getTextWithMacros(), "");
        }
        if (expr instanceof OCQualifiedExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCQualifiedExpression)expr).getName(), "");
        }
        if (expr instanceof OCSendMessageExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCSendMessageExpression)expr).getMessageSelector(), "");
        }
        if (expr instanceof OCCallExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCCallExpression)expr).getFunctionReferenceExpression().getTextWithMacros(), "");
        }
        return Collections.emptyList();
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement context, Collection<String> forbiddenNames) {
        return OCNameSuggester.convertToUniqueNames(null, OCNameSuggester.doSuggestForType(type, "", context), context, forbiddenNames);
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement context, String prefix) {
        return OCNameSuggester.convertToUniqueNames(null, OCNameSuggester.doSuggestForType(type, prefix, context), context, Collections.<String>emptyList());
    }

    public static Collection<String> suggestForType(OCSymbolKind symbolKind, OCType type, @Nullable PsiElement context, String prefix) {
        return OCNameSuggester.convertToUniqueNames(symbolKind, OCNameSuggester.doSuggestForType(type, prefix, context), context, Collections.<String>emptyList());
    }

    private static Collection<String> doSuggestForType(OCType type, String prefix, @Nullable PsiElement context) {
        if (type == null) {
            return Collections.emptyList();
        }
        if (context != null && OCIntType.isBool(type, context)) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        if (type instanceof OCIntType) {
            return OCNameSuggester.doSuggestForSimpleType(INT_SHORT_NAME, INT_LONG_NAME, prefix);
        }
        if (type instanceof OCRealType) {
            return OCNameSuggester.doSuggestForSimpleType(DOUBLE_SHORT_NAME, DOUBLE_LONG_NAME, prefix);
        }
        if (type.isCString()) {
            return OCNameSuggester.doGetSuggestionsByName(STRING_SHORT_NAME, prefix);
        }
        if (type instanceof OCPointerType) {
            OCType ref = ((OCPointerType)type).getRefType();
            Collection<String> raw = OCNameSuggester.doSuggestForType(ref, !prefix.isEmpty() || ref instanceof OCObjectType || ref instanceof OCReferenceType ? prefix : "p", context);
            return raw.isEmpty() ? Collections.singleton(POINTER_SHORT_NAME) : raw;
        }
        if (type instanceof OCObjectType) {
            OCClassSymbol smb = ((OCObjectType)type).getClassSymbol();
            if (smb == null) {
                return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
            }
            return OCNameSuggester.doSuggestionsByTypeName(smb.getName(), prefix);
        }
        if (type instanceof OCFunctionType) {
            return OCNameSuggester.doSuggestForSimpleType(FUNCTION_SHORT_NAME, FUNCTION_LONG_NAME, prefix);
        }
        if (type instanceof OCVoidType) {
            return OCNameSuggester.doSuggestForSimpleType(VOID_SHORT_NAME, VOID_LONG_NAME, prefix);
        }
        if (type instanceof OCAutoType) {
            return OCNameSuggester.doSuggestForSimpleType(AUTO_SHORT_NAME, AUTO_SHORT_NAME, prefix);
        }
        if (type instanceof OCReferenceType) {
            return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
        }
        if (type instanceof OCStructType) {
            return OCNameSuggester.doSuggestionsByTypeName(((OCStructType)type).getSymbol().getName(), prefix);
        }
        if (type instanceof OCCppReferenceType) {
            return OCNameSuggester.doSuggestForType(((OCCppReferenceType)type).getRefType(), prefix, context);
        }
        return Collections.emptyList();
    }

    private static Collection<String> doSuggestionsByTypeName(String typeName, String prefix) {
        int pos = typeName.indexOf(60);
        if (pos != -1) {
            typeName = typeName.substring(0, pos);
        }
        if (typeName.equals("id")) {
            return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
        }
        if (typeName.equals("BOOL")) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        if (typeName.startsWith("NS")) {
            typeName = typeName.substring(2);
        }
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)OCNameSuggester.stripSuffixes(typeName), (String)"const"), prefix);
    }

    private static Collection<String> doSuggestForSimpleType(String shortName, String longName, String prefix) {
        return Collections.singleton(!prefix.isEmpty() ? prefix + StringUtil.capitalize((String)longName) : shortName);
    }

    private static String stripSuffixes(String suggestion) {
        for (String suff : GARBAGE_SUFFIXES) {
            if (!StringUtil.endsWith((CharSequence)suggestion, (CharSequence)suff)) continue;
            return OCNameSuggester.stripSuffixes(suggestion.substring(0, suggestion.length() - suff.length()));
        }
        return suggestion;
    }

    private static List<String> doGetSuggestionsByName(String name, String prefix) {
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)name, (String)"get"), false, prefix, "");
    }

    private static List<String> doGetSuggestionsByName(String name, boolean uppercaseStyle, String prefix, String suffix) {
        List raw = NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)uppercaseStyle, (boolean)false, (boolean)false);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : raw) {
            String s = OCNameSuggester.changeIfNotIdentifier(suggestion);
            if (!OCNamesValidator.isIdentifier(s) || OCNamesValidator.isKeyword(s)) continue;
            answer.add(s);
        }
        return answer;
    }

    @NonNls
    private static String changeIfNotIdentifier(String name) {
        if (!OCNamesValidator.isIdentifier(name = StringUtil.trimEnd((String)name, (String)":"))) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    public static String suggestUniqueName(OCSymbol symbol, PsiElement scope) {
        return OCNameSuggester.suggestUniqueName(symbol.getKind(), symbol.getName(), scope);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, PsiElement scope) {
        return OCNameSuggester.suggestUniqueName(symbolKind, baseName, scope, Collections.<String>emptyList());
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames) {
        return OCNameSuggester.suggestUniqueName(symbolKind, baseName, scope != null ? Collections.singletonList(scope) : Collections.emptyList(), forbiddenNames);
    }

    private static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, List<PsiElement> scopes, Collection<String> forbiddenNames) {
        int count = 0;
        while (true) {
            String candidate = count > 0 ? baseName + count : baseName;
            boolean isUnique = true;
            if (forbiddenNames.contains(candidate)) {
                isUnique = false;
            }
            for (PsiElement scope : scopes) {
                if (scope == null || OCCodeInsightUtil.isUniqueInScope(symbolKind, candidate, scope, scope.getProject())) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return candidate;
            }
            ++count;
        }
    }

    private static Collection<String> convertToUniqueNames(@Nullable OCSymbolKind symbolKind, Collection<String> candidates, @Nullable PsiElement scope, Collection<String> forbiddenNames) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        LinkedHashSet<String> augmented = new LinkedHashSet<String>();
        for (String candidate : candidates) {
            String unique = OCNameSuggester.suggestUniqueName(symbolKind, candidate, scope, forbiddenNames);
            if (Comparing.equal((String)unique, (String)candidate)) {
                answer.add(unique);
                continue;
            }
            augmented.add(unique);
        }
        answer.addAll(augmented);
        return answer;
    }

    public static String removeVariablePrefixes(String name) {
        if (name.startsWith("an")) {
            name = StringUtil.decapitalize((String)name.substring(2));
        } else if (name.startsWith("a") || name.startsWith("_")) {
            name = StringUtil.decapitalize((String)name.substring(1));
        }
        return name;
    }

    public static String removeSelectorPrefixes(String selectorPart) {
        if (selectorPart.startsWith("and")) {
            selectorPart = StringUtil.decapitalize((String)selectorPart.substring(3));
        }
        return selectorPart;
    }

    public static String suggestForParameter(Collection<String> prevParamNames, boolean isFirstSelector, String selector, OCType type, @Nullable OCMethodSymbol method, @Nullable OCExpression expression) {
        String paramName = isFirstSelector || selector.equals(":") ? OCNameSuggester.suggestForParameter(prevParamNames, type, expression) : (selector.endsWith(":") ? StringUtil.decapitalize((String)OCNameSuggester.getLastSubword(selector.substring(0, selector.length() - 1))) : "param");
        final ArrayList<PsiElement> contexts = new ArrayList<PsiElement>();
        if (method != null) {
            method.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    Object definition = symbol.locateDefinition();
                    if (definition != null) {
                        contexts.add(definition);
                    }
                    return true;
                }
            });
        }
        return OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, paramName, contexts, prevParamNames);
    }

    public static String suggestForParameter(Collection<String> forbiddenNames, OCType type, @Nullable OCExpression expression) {
        Collection<String> suggestedNames = new ArrayList<String>(OCNameSuggester.doSuggestForType(type, "", expression));
        suggestedNames.addAll(OCNameSuggester.doSuggestionForContext(expression));
        suggestedNames = OCNameSuggester.convertToUniqueNames(null, suggestedNames, null, forbiddenNames);
        for (String name : suggestedNames) {
            if (ArrayUtil.contains((String)name, (String[])SHORT_NAMES)) continue;
            return name;
        }
        return suggestedNames.isEmpty() ? "param" : suggestedNames.iterator().next();
    }

    public static String getLastSubword(String word) {
        String[] subwords = NameUtil.nameToWords((String)word);
        String result2 = "";
        for (int i = subwords.length - 1; i >= 0; --i) {
            result2 = subwords[i] + result2;
            if (!StringUtil.isJavaIdentifier((String)result2)) continue;
            return result2;
        }
        return word;
    }

    public static String getSelectorNameWithoutParameter(String firstSelector, @Nullable String paramName) {
        if (paramName == null) {
            return firstSelector;
        }
        if (firstSelector.endsWith(StringUtil.capitalize((String)(paramName = OCNameSuggester.removeVariablePrefixes(paramName))))) {
            firstSelector = firstSelector.substring(0, firstSelector.length() - paramName.length());
        }
        return firstSelector;
    }

    public static String getNonCollidingName(OCSymbol symbol) {
        return OCNameSuggester.getNonCollidingName(symbol, false);
    }

    public static String getNonCollidingName(OCSymbol symbol, boolean allowCollision) {
        return OCNameSuggester.getNonCollidingName(symbol.getName(), symbol.getKind(), allowCollision, symbol.getProject());
    }

    public static String getNonCollidingName(String name, OCSymbolKind symbolKind, boolean allowCollision, Project project) {
        String suffix;
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        String prefix = settings != null ? settings.IVARS_PREFIX : "_";
        String string = suffix = settings != null ? settings.IVARS_SUFFIX : "";
        if (symbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            String newName = OCNameSuggester.getNameWithoutPrefixAndSuffix(name, prefix, suffix);
            if (newName.equals(name) && !allowCollision) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
            }
            return newName;
        }
        if (symbolKind == OCSymbolKind.PROPERTY) {
            return OCNameSuggester.getNameWithPrefixAndSuffix(name, prefix, suffix);
        }
        if (!allowCollision) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    private static String getNameWithPrefixAndSuffix(String name, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (isLetterPrefix) {
            return prefix + StringUtil.capitalize((String)name) + suffix;
        }
        return prefix + name + suffix;
    }

    private static String getNameWithoutPrefixAndSuffix(String name, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (name.length() > prefix.length() && prefix.length() + suffix.length() > 0 && (isLetterPrefix ? OCElementUtil.startsWithWord(name, prefix) : name.startsWith(prefix))) {
            String result2 = name.substring(prefix.length());
            if (isLetterPrefix) {
                result2 = StringUtil.decapitalize((String)result2);
            }
            if (result2.endsWith(suffix) && result2.length() > suffix.length()) {
                result2 = result2.substring(0, result2.length() - suffix.length());
            }
            if (OCNamesValidator.isKeyword(result2)) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)result2);
            }
            return result2;
        }
        return name;
    }

    @NotNull
    public static String getClang4ImplicitIvarName(String propertyName) {
        String string = "_" + propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/OCNameSuggester", "getClang4ImplicitIvarName"));
        }
        return string;
    }

    @Nullable
    public static String getClang4PropertyName(String implicitIvarName) {
        return implicitIvarName.startsWith("_") ? implicitIvarName.substring(1) : null;
    }

    public static String getCppFieldNameWithoutPrefixAndSuffix(OCDeclaratorSymbol field) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)field.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String prefix = settings != null ? settings.FIELDS_PREFIX : "";
        String suffix = settings != null ? settings.FIELDS_SUFFIX : "";
        return OCNameSuggester.getNameWithoutPrefixAndSuffix(field.getName(), prefix, suffix);
    }

    public static String getCppGetterName(OCDeclaratorSymbol field) {
        String fieldName;
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)field.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String getterPrefix = settings != null ? settings.GETTERS_PREFIX : "get";
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field);
        if (name.equals(fieldName = field.getName()) && getterPrefix.isEmpty()) {
            getterPrefix = "get";
        }
        boolean isBoolField = OCIntType.isBool(field.getResolvedType(), field.getContainingOCFile());
        if (getterPrefix.equals("get") && isBoolField) {
            getterPrefix = "is";
            if (!name.equals(fieldName) && OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name), getterPrefix)) {
                getterPrefix = "";
                name = StringUtil.decapitalize((String)name);
            }
        }
        if (getterPrefix.equals("Get") && isBoolField) {
            getterPrefix = "Is";
            if (!name.equals(fieldName) && OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name), StringUtil.decapitalize((String)getterPrefix))) {
                getterPrefix = "";
                name = StringUtil.capitalize((String)name);
            }
        }
        return OCNameSuggester.getNameWithPrefixAndSuffix(name, getterPrefix, "");
    }

    public static String getCppSetterName(OCDeclaratorSymbol field) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)field.getProject()).getCustomSettings(OCCodeStyleSettings.class);
        String setterPrefix = settings != null ? settings.SETTERS_PREFIX : "set";
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field);
        if (name.equals(field.getName()) && setterPrefix.isEmpty()) {
            setterPrefix = "set";
        }
        return OCNameSuggester.getNameWithPrefixAndSuffix(name, setterPrefix, "");
    }

    public static boolean isObjCGetter(String name) {
        return !name.endsWith(":");
    }

    public static boolean isObjCSetter(String name) {
        return name.indexOf(58) == name.length() - 1;
    }

    public static String getObjCSetterFromGetter(String getter) {
        return "set" + StringUtil.capitalize((String)getter) + ":";
    }

    @Nullable
    public static String getObjCGetterFromSetter(String setter) {
        if (OCElementUtil.startsWithWord(setter, "set") && setter.length() > 4 && OCNameSuggester.isObjCSetter(setter)) {
            return StringUtil.decapitalize((String)setter.substring(3, setter.length() - 1));
        }
        return null;
    }
}

