/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class OCSynthesizePropertyQuickFixBase
extends OCGenerateIvarsHandler
implements IntentionAction {
    protected OCImplementationSymbol myImplementationSymbol;
    protected OCPropertySymbol myProperty;

    public OCSynthesizePropertyQuickFixBase(OCImplementationSymbol implementationSymbol, OCPropertySymbol property) {
        this.myImplementationSymbol = implementationSymbol;
        this.myProperty = property;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getText"));
            }
            return "Invalid";
        }
        String string = "Synthesize " + this.myProperty.getNameWithKindLowercase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "isAvailable"));
        }
        return OCSearchScope.isInProjectSources(this.myImplementationSymbol) && this.myProperty != null;
    }

    @Override
    protected OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "locateCandidate"));
        }
        return this.myProperty;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getParent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCSynthesizePropertyQuickFixBase", "getParent"));
        }
        return this.myImplementationSymbol;
    }

    @Override
    protected boolean replaceAllProperties() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }
}

