/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCReuseDeclarationIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private String myIntentionName;

    public OCReuseDeclarationIntentionAction(OCSymbol symbol, String intentionName) {
        super(symbol);
        this.myIntentionName = intentionName;
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        if ("Reuse declaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCReuseDeclarationIntentionAction", "getFamilyName"));
        }
        return "Reuse declaration";
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol) && OCCodeInsightUtil.isValid(symbol.locateDefinition());
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        OCDeclarator declarator = (OCDeclarator)symbol.locateDefinition();
        if (declarator == null) {
            return;
        }
        if (declarator.getInitializer() != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(declarator.getName() + "=b;", declarator) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + declarator.getName() + "=b;;);", declarator)).getInitializer();
            OCAssignmentExpression expr = (OCAssignmentExpression)assignment.getExpression();
            OCChangeUtil.replaceHandlingMacros(expr.getSourceExpression(), declarator.getInitializer());
            OCDeclaration declaration = (OCDeclaration)declarator.getParent();
            PsiElement parent = declaration.getParent();
            if (!(parent instanceof OCDeclarationStatement)) {
                return;
            }
            parent.getParent().addAfter((PsiElement)assignment, parent);
        }
        if (declarator.getParent().getParent() instanceof OCForeachStatement) {
            OCExpression expression = OCElementFactory.expressionFromText(declarator.getName(), declarator);
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), expression);
        } else {
            OCChangeUtil.delete(declarator);
        }
    }
}

