/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameSymbolIntentionAction
extends OCSymbolQuickFix<OCSymbol>
implements HighPriorityAction {
    public OCRenameSymbolIntentionAction(OCSymbol symbol) {
        super(symbol);
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCSearchScope.isInProjectSources(symbol);
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return "Rename " + symbol.getNameWithKindLowercase();
    }

    @NotNull
    public String getFamilyName() {
        if ("Rename symbol" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCRenameSymbolIntentionAction", "getFamilyName"));
        }
        return "Rename symbol";
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCRenameSymbolIntentionAction", "invoke"));
        }
        if (file2 != null && FileModificationService.getInstance().prepareFileForWrite(file2)) {
            OCInplaceRenamer renamer;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            Object element = this.mySymbol.locateDefinition();
            if (element != null && editor != null && (renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer((PsiElement)element, editor)) != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    renamer.performRenameInner((PsiElement)element, "renamed");
                } else {
                    renamer.performInplaceRename();
                }
            }
        }
    }

    @Override
    protected void invoke(OCSymbol symbol) {
    }
}

