/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameReferenceIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    public OCRenameReferenceIntentionAction(@Nullable PsiElement element) {
        super(element);
    }

    @Override
    protected String getTextInternal() {
        return "Rename Reference";
    }

    @NotNull
    public String getFamilyName() {
        if ("Rename reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCRenameReferenceIntentionAction", "getFamilyName"));
        }
        return "Rename reference";
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCRenameReferenceIntentionAction", "isAvailable"));
        }
        return !ApplicationManager.getApplication().isUnitTestMode() && (element instanceof OCReferenceElement || element instanceof OCQualifiedExpression);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCRenameReferenceIntentionAction", "invoke"));
        }
        if (FileModificationService.getInstance().prepareFileForWrite(file2)) {
            PsiReference reference;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiElement element = this.myElementPtr.getElement();
            PsiReference psiReference = reference = element != null ? element.getReference() : null;
            if (reference != null) {
                OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(editor, file2, project, reference, null, reference.getCanonicalText());
                ((VariableInplaceRenamer)renamer).performInplaceRename();
            }
        }
    }
}

