/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCRemoveExtraInitializersIntentionAction
extends OCPsiElementsQuickFix {
    private int myStartIndex;

    public OCRemoveExtraInitializersIntentionAction(List<? extends PsiElement> initializers, int startIndex) {
        super(initializers);
        this.myStartIndex = startIndex;
    }

    @Override
    protected String getTextInternal() {
        return "Remove extra initializers";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getTextInternal();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCRemoveExtraInitializersIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable() {
        return this.myElementPointers != null && this.myElementPointers.size() > this.myStartIndex && OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file2) {
        for (int i = this.myElementPointers.size() - 1; i >= this.myStartIndex; --i) {
            PsiElement element = ((SmartPsiElementPointer)this.myElementPointers.get(i)).getElement();
            if (element == null) continue;
            OCChangeUtil.delete(element);
        }
    }
}

