/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveElementsIntentionAction
extends OCPsiElementsQuickFix {
    private String myIntentionName;
    private String myFamilyName;

    public OCRemoveElementsIntentionAction(@Nullable PsiElement element, String intentionName) {
        this(element, intentionName, intentionName);
    }

    public OCRemoveElementsIntentionAction(PsiElement element, String intentionName, String familyName) {
        this(Collections.singletonList(element), intentionName, familyName);
    }

    public OCRemoveElementsIntentionAction(Collection<? extends PsiElement> elements, String intentionName, String familyName) {
        super(elements);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCRemoveElementsIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(PsiFile file2) {
        this.processElements(new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof OCStatement) {
                    OCChangeUtil.safeDeleteStatement((OCStatement)element);
                } else {
                    OCChangeUtil.delete(element);
                }
                return true;
            }
        });
    }
}

