/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCQuickFix
implements IntentionAction,
LocalQuickFix {
    protected abstract String getTextInternal();

    protected abstract boolean isAvailable();

    protected void invoke(PsiFile file2) {
    }

    @NotNull
    public String getText() {
        if (!this.isAvailable()) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "getText"));
            }
            return "Invalid";
        }
        String string = this.getTextInternal();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "getName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "isAvailable"));
        }
        return this.isAvailable();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "invoke"));
        }
        if (FileModificationService.getInstance().prepareFileForWrite(file2)) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            this.invoke(file2);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/cidr/lang/quickfixes/OCQuickFix", "applyFix"));
        }
        if (this.isAvailable()) {
            PsiFile file2 = descriptor.getPsiElement().getContainingFile();
            this.invoke(file2.getProject(), null, file2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isSupportedInBatchMode() {
        return true;
    }
}

