/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFixBase;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCMakePropertyDynamicQuickFix
extends OCSynthesizePropertyQuickFixBase
implements LowPriorityAction {
    public OCMakePropertyDynamicQuickFix(OCImplementationSymbol implementationSymbol, OCPropertySymbol property) {
        super(implementationSymbol, property);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            if ("Invalid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix", "getText"));
            }
            return "Invalid";
        }
        String string = "Make " + this.myProperty.getNameWithKindLowercase() + " @dynamic";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix", "getText"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCClassDeclarationBase decl = (OCClassDeclarationBase)this.myImplementationSymbol.locateDefinition();
        if (!(decl instanceof OCImplementation) || !FileModificationService.getInstance().prepareFileForWrite(decl.getContainingFile())) {
            return;
        }
        OCImplementation implementation = (OCImplementation)decl;
        OCSynthesizePropertiesList declaration = OCElementFactory.synthesizeList("@dynamic", this.myProperty.getName(), null, (PsiElement)file2);
        OCInstanceVariablesList ivars = implementation.getInstanceVariablesList();
        implementation.addBefore(declaration, ivars.getNextSibling());
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

