/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementPropertyAccessorsQuickFix
extends OCImplementOCMethodsHandler
implements IntentionAction {
    private OCPropertySymbol myProperty;

    public OCImplementPropertyAccessorsQuickFix(OCPropertySymbol property) {
        this.myProperty = property;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Implement accessor methods for " + this.myProperty.getNameWithKindLowercase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "isAvailable"));
        }
        return OCSearchScope.isInProjectSources(this.myProperty);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getParent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getParent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getParent"));
        }
        return (OCClassSymbol)this.myProperty.getParent();
    }

    @Override
    protected List<Pair<OCOption, Object>> loadOptions(PsiFile file2, @Nullable OCCodeStyleSettings settings, @NotNull OCOverrideImplementActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "loadOptions"));
        }
        ArrayList<Pair<OCOption, Object>> result2 = new ArrayList<Pair<OCOption, Object>>();
        result2.add(new Pair((Object)SHOW_OPTIONAL, (Object)false));
        result2.add(new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)true));
        return result2;
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(OCOverrideImplementActionContext context, Editor editor, PsiFile file2, List<OCMethodSymbol> candidates) {
        CommonProcessors.CollectProcessor<OCMethodSymbol> collector = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                if (method.getGeneratedFromProperty() == OCImplementPropertyAccessorsQuickFix.this.myProperty) {
                    return super.process((Object)method);
                }
                return true;
            }
        };
        ((OCClassSymbol)this.myProperty.getParent()).processMembers(OCMethodSymbol.class, collector);
        Collection collection = collector.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCImplementPropertyAccessorsQuickFix", "getSelectedCandidates"));
        }
        return collection;
    }
}

