/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.NotNull;

public class OCConvertLiteralIntentionAction
extends OCPsiElementQuickFix<OCExpression>
implements HighPriorityAction {
    private OCType myLeftType;
    private OCType myRightType;

    public OCConvertLiteralIntentionAction(OCExpression expression, OCType leftType, OCType rightType) {
        super(OCParenthesesUtils.diveIntoParentheses(expression));
        this.myLeftType = leftType;
        this.myRightType = rightType;
    }

    @Override
    protected String getTextInternal() {
        return "Convert literal type: add '@'";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getTextInternal();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCConvertLiteralIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable() {
        OCExpression expression = (OCExpression)this.myElementPtr.getElement();
        if (this.myLeftType == null || this.myRightType == null || !(expression instanceof OCLiteralExpression) || !OCSearchScope.isInProjectSources(expression.getParent())) {
            return false;
        }
        OCMacroRange call = OCElementUtil.getRangeInMacroCall(expression);
        if (call != null && !call.mapsToArguments()) {
            return false;
        }
        boolean isIdOrObject = this.myLeftType.isObjCRootType();
        return (this.myLeftType.isPointerToStringCompatible() || isIdOrObject) && this.myRightType.isPointerToChar() || (this.myLeftType.getName().equals("NSNumber *") || isIdOrObject) && this.myRightType instanceof OCNumericType && OCCompilerHelper.supportsObjectLiterals(expression.getContainingOCFile());
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/quickfixes/OCConvertLiteralIntentionAction", "invoke"));
        }
        OCChangeUtil.changeText(file2.getProject(), file2, expression.getRangeWithMacros().getStartOffset(), 0, "@", false);
    }
}

