/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCLValueVisitor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeTypeIntentionAction
extends OCQuickFix {
    @Nullable
    private OCSymbol mySymbol;
    private OCType mySubstitutionType;
    private String mySubject;
    private String myMessageSuffix = "";
    private boolean myReturnTypeMode;
    private boolean myChangeAssociatedSymbol = true;
    private boolean myChangeProperty;

    public OCChangeTypeIntentionAction(@Nullable OCSymbol symbol, OCType substitutionType) {
        this.mySymbol = symbol;
        this.mySubstitutionType = substitutionType;
        if (this.mySymbol != null) {
            this.mySubject = this.mySymbol.getNameWithKindLowercase();
        }
    }

    public OCChangeTypeIntentionAction(@Nullable OCSymbol symbol, OCType substitutionType, boolean returnTypeMode) {
        this(symbol, substitutionType, returnTypeMode, null);
    }

    public OCChangeTypeIntentionAction(@Nullable OCSymbol symbol, OCType substitutionType, boolean returnTypeMode, @Nullable String subject) {
        this(symbol, substitutionType, subject);
        this.myReturnTypeMode = returnTypeMode;
        if (this.myReturnTypeMode && symbol != null && symbol.getKind().isFunction() && substitutionType.getTerminalType() instanceof OCFunctionType) {
            this.mySubstitutionType = OCPointerType.to(OCVoidType.instance());
        }
    }

    public OCChangeTypeIntentionAction(@Nullable OCSymbol symbol, OCType substitutionType, @Nullable String subject) {
        this(symbol, substitutionType);
        if (subject != null) {
            this.mySubject = subject;
        }
    }

    public OCChangeTypeIntentionAction(OCSymbol symbol, OCType substitutionType, String messageSuffix, boolean changeAssociatedSymbol) {
        this(symbol, substitutionType);
        this.myMessageSuffix = messageSuffix;
        this.myChangeAssociatedSymbol = changeAssociatedSymbol;
    }

    public static OCChangeTypeIntentionAction getAction(@NotNull OCExpression expression, OCType substitutionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/lang/quickfixes/OCChangeTypeIntentionAction", "getAction"));
        }
        OCLValueVisitor visitor = new OCLValueVisitor(true);
        expression.accept(visitor);
        boolean returnTypeMode = OCParenthesesUtils.diveIntoParentheses(expression) instanceof OCCallExpression;
        if (!returnTypeMode) {
            substitutionType = OCPointerType.to(substitutionType, visitor.getNumOfDereferences());
        }
        return new OCChangeTypeIntentionAction(visitor.getSymbol(), substitutionType, returnTypeMode);
    }

    @Override
    protected String getTextInternal() {
        return "Change " + (this.myReturnTypeMode || this.mySymbol instanceof OCMethodSymbol ? "return " : "") + "type of " + this.mySubject + " to '" + this.mySubstitutionType.getName(this.mySymbol.getContainingOCFile()) + "'" + this.myMessageSuffix;
    }

    @NotNull
    public String getFamilyName() {
        if ("Change type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeTypeIntentionAction", "getFamilyName"));
        }
        return "Change type";
    }

    @Override
    protected boolean isAvailable() {
        if (!(OCSearchScope.isInProjectSources(this.mySymbol) && (OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition()) || this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar()))) {
            return false;
        }
        OCType type = this.mySymbol.getType();
        if (this.mySymbol instanceof OCDeclaratorSymbol && type instanceof OCStructType && !((OCStructType)type).isPredeclaration()) {
            return this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType().getName().equals(type.getName());
        }
        if (this.mySymbol instanceof OCFunctionSymbol && type instanceof OCFunctionType && this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType() instanceof OCPointerType) {
            return false;
        }
        return this.mySubstitutionType.isInstanceable() || this.mySymbol.isCallable();
    }

    @Override
    protected void invoke(final PsiFile file2) {
        final ArrayList<OCSymbol> symbolsToChange = new ArrayList<OCSymbol>();
        final OCSymbol associatedSymbol = this.mySymbol.getAssociatedSymbol();
        if (this.mySymbol instanceof OCMemberSymbol && this.myChangeAssociatedSymbol) {
            ((OCClassSymbol)((OCMemberSymbol)this.mySymbol).getParent()).processMembersInAllCategories(this.mySymbol.getName(), this.mySymbol.getClass(), new Processor<OCMemberSymbol>(){

                public boolean process(OCMemberSymbol member) {
                    if (member != associatedSymbol && !member.isSynthetic() && OCChangeTypeIntentionAction.this.needToChangeType(member, file2)) {
                        symbolsToChange.add(member);
                    }
                    return true;
                }
            }, false);
        } else if ((this.mySymbol instanceof OCFunctionSymbol || this.mySymbol instanceof OCDeclaratorSymbol) && this.myChangeAssociatedSymbol) {
            this.mySymbol.processSameSymbols(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (OCChangeTypeIntentionAction.this.needToChangeType(symbol, file2)) {
                        symbolsToChange.add(symbol);
                    }
                    return true;
                }
            });
        } else {
            symbolsToChange.add(this.mySymbol);
        }
        if (this.myChangeAssociatedSymbol) {
            OCPropertySymbol property;
            if (associatedSymbol != null && this.needToChangeType(associatedSymbol, file2)) {
                symbolsToChange.add(associatedSymbol);
            }
            if (this.mySymbol instanceof OCPropertySymbol) {
                ((OCPropertySymbol)this.mySymbol).processAccessorMethods((Processor<? super OCMethodSymbol>)new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol method) {
                        if (method.isGetter()) {
                            symbolsToChange.add(method);
                        } else if (method.isSetter()) {
                            symbolsToChange.add(method.getSelectors().get(0).getParameter());
                        }
                        return true;
                    }
                }, true);
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)this.mySymbol).getAssociatedIvar();
                if (ivar != null && this.needToChangeType(ivar, file2)) {
                    int code;
                    String message = "Do you want to change type of " + ivar.getNameWithKindLowercase() + " as well?";
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() || ivar.isClang4ImplicitIvar() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)"Change Type", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(ivar);
                    } else if (code == 2) {
                        return;
                    }
                }
            } else if (this.mySymbol instanceof OCInstanceVariableSymbol && (property = ((OCInstanceVariableSymbol)this.mySymbol).getAssociatedProperty()) != null && this.needToChangeType(property, file2)) {
                if (((OCInstanceVariableSymbol)this.mySymbol).getGeneratedFromProperty() != null) {
                    symbolsToChange.add(property);
                    this.myChangeProperty = true;
                } else {
                    int code;
                    String message = "Do you want to change type of " + property.getNameWithKindLowercase() + " as well?";
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)"Change Type", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(property);
                        this.myChangeProperty = true;
                    } else if (code == 2) {
                        return;
                    }
                }
            }
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                HashMap<OCSymbol, SmartPsiElementPointer> elementPtrs = new HashMap<OCSymbol, SmartPsiElementPointer>();
                for (OCSymbol symbol : symbolsToChange) {
                    PsiElement element = symbol != null ? (PsiElement)symbol.locateDefinition() : null;
                    if (element == null) continue;
                    elementPtrs.put(symbol, SmartPointerManager.getInstance((Project)OCChangeTypeIntentionAction.this.mySymbol.getProject()).createSmartPsiElementPointer(element));
                }
                for (OCSymbol symbol : elementPtrs.keySet()) {
                    OCChangeTypeIntentionAction.this.doChangeType(((SmartPsiElementPointer)elementPtrs.get(symbol)).getElement(), symbol);
                }
            }
        });
    }

    private boolean needToChangeType(OCSymbol symbol, @NotNull PsiFile file2) {
        OCType type;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/quickfixes/OCChangeTypeIntentionAction", "needToChangeType"));
        }
        OCType oCType = type = symbol instanceof OCMethodSymbol ? ((OCMethodSymbol)symbol).getReturnType() : symbol.getType();
        if (this.myReturnTypeMode) {
            if (!(type instanceof OCFunctionType)) {
                return true;
            }
            type = ((OCFunctionType)type).getReturnType();
        }
        if (type.resolve(file2) instanceof OCTypeParameterType) {
            return false;
        }
        return !new OCTypeEqualityAfterResolvingVisitor(this.mySubstitutionType, false, false, false, true, false, file2).equal(type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doChangeType(PsiElement element22, OCSymbol symbol) {
        void element22;
        OCTypeElement typeElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(element22.getContainingFile())) {
            return;
        }
        OCDeclarator myDeclarator = null;
        OCType type = this.mySubstitutionType;
        if (element22 instanceof OCDeclarator) {
            myDeclarator = (OCDeclarator)element22;
            typeElement = ((OCDeclaration)element22.getParent()).getTypeElement();
        } else if (element22 instanceof OCMethodSelectorPart) {
            typeElement = ((OCMethodSelectorPart)element22).getTypeElement();
        } else if (element22 instanceof OCMethod) {
            typeElement = ((OCMethod)element22).getReturnTypeElement();
        } else if (element22 instanceof OCBlockExpression) {
            typeElement = ((OCBlockExpression)element22).getReturnTypeElement();
        } else if (element22 instanceof OCLambdaExpression) {
            typeElement = ((OCLambdaExpression)element22).getReturnTypeElement();
        } else {
            if (!(element22 instanceof OCReferenceElement) || !(element22.getParent() instanceof OCSynthesizeProperty) || !this.myChangeProperty) return;
            Object element22 = (symbol = ((OCInstanceVariableSymbol)((Object)symbol)).getAssociatedProperty()).locateDefinition();
            if (!(element22 instanceof OCDeclarator)) return;
            myDeclarator = (OCDeclarator)element22;
            typeElement = ((OCDeclaration)element22.getParent()).getTypeElement();
        }
        if (typeElement == null) {
            void var7_14;
            void element22;
            if (!(element22 instanceof OCBlockExpression)) return;
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext((PsiElement)element22), (PsiElement)element22);
            OCParameterList oCParameterList = ((OCBlockExpression)element22).getParameterList();
            if (oCParameterList == null) {
                OCBlockStatement oCBlockStatement = ((OCBlockExpression)element22).getBody();
            }
            element22.addBefore((PsiElement)newTypeElement, (PsiElement)var7_14);
            return;
        }
        if (myDeclarator != null) {
            OCDeclaration declaration = OCNormalizeUtil.normalizeDeclarator(myDeclarator);
            if (declaration == null) {
                return;
            }
            PsiElement element22 = declaration.getDeclarators().get(0);
            PsiElement psiElement = OCElementFactory.binaryOperatorFromText("*", element22);
            PsiElement roof = OCElementFactory.binaryOperatorFromText("^", element22);
            PsiElement ampersand = OCElementFactory.binaryOperatorFromText("&", element22);
            PsiElement constKeyword = OCElementFactory.create(OCTokenTypes.CONST_KEYWORD, element22);
            PsiElement volatileKeyword = OCElementFactory.create(OCTokenTypes.VOLATILE_KEYWORD, element22);
            ArrayList<PsiElement> declaratorModifiers = new ArrayList<PsiElement>();
            boolean isBlockType = type instanceof OCBlockPointerType;
            if (!this.myReturnTypeMode) {
                while ((type instanceof OCPointerType && !type.isPointerToID() || type instanceof OCCppReferenceType) && type.getAliasName() == null) {
                    if (type.isConst()) {
                        declaratorModifiers.add(0, constKeyword);
                    }
                    if (type.isVolatile()) {
                        declaratorModifiers.add(0, volatileKeyword);
                    }
                    if (type instanceof OCCppReferenceType) {
                        declaratorModifiers.add(0, ampersand);
                        type = ((OCCppReferenceType)type).getRefType();
                        continue;
                    }
                    declaratorModifiers.add(0, isBlockType && declaratorModifiers.isEmpty() ? roof : psiElement);
                    type = ((OCPointerType)type).getRefType();
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    boolean isPointerToFunction = declarator.isPointerToFunction();
                    this.removeAllModifiers(declarator);
                    if (declaration instanceof OCFunctionDeclaration && !isPointerToFunction) continue;
                    for (PsiElement token : declaratorModifiers) {
                        OCChangeTypeIntentionAction.addModifier(declarator, token.copy());
                    }
                }
                if (type instanceof OCFunctionType) {
                    if (((OCDeclarator)element22).getParameterList() != null) {
                        OCChangeTypeIntentionAction.changeFunctionType((OCDeclarator)element22, (OCFunctionType)type);
                        return;
                    } else {
                        OCDeclarationStatement newDeclaration = OCElementFactory.declarationStatement(myDeclarator.getName(), this.mySubstitutionType, myDeclarator.getInitializer(), declaration);
                        OCChangeUtil.replaceHandlingMacros(declaration, newDeclaration.getDeclaration());
                    }
                    return;
                }
            } else if (declaration instanceof OCFunctionDeclaration) {
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    this.removeAllModifiers(declarator);
                }
            }
            typeElement = declaration.getTypeElement();
            this.removeAllModifiers(typeElement);
            if (typeElement == null || typeElement.getType().equals((Object)type, typeElement)) {
                return;
            }
        }
        if (element22 instanceof OCBlockExpression && type.isVoid()) {
            OCChangeUtil.delete(typeElement);
            return;
        } else {
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext(typeElement), (PsiElement)element22);
            OCElementUtil.replaceDeclarationQualifiers(newTypeElement, typeElement);
            typeElement = (OCTypeElement)OCChangeUtil.replaceHandlingMacros(typeElement, newTypeElement);
            OCImportSymbolFix.fixAllSymbolsRecursively(typeElement);
        }
    }

    private static void changeFunctionType(OCDeclarator declarator, OCFunctionType newFunctionType) {
        OCFunctionDeclaration functionDef;
        OCParameterList parameterList = declarator.getParameterList();
        if (declarator.getParent() instanceof OCFunctionDeclaration && !(functionDef = (OCFunctionDeclaration)declarator.getParent()).getReturnType().equalsAfterResolving(newFunctionType.getReturnType(), (PsiElement)declarator.getContainingFile())) {
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newFunctionType.getReturnType().getBestNameInContext(declarator), declarator);
            OCChangeUtil.replaceHandlingMacros(functionDef.getTypeElement(), newTypeElement);
        }
        if (parameterList == null) {
            return;
        }
        Iterator<? extends OCType> newTypesItr = newFunctionType.getParameterTypes(true).iterator();
        HashSet<String> createdNames = new HashSet<String>();
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            if (newTypesItr.hasNext()) {
                OCType newType = newTypesItr.next();
                OCDeclarator paramDeclarator = param.getDeclarator();
                if (paramDeclarator != null) {
                    if (paramDeclarator.getType().equalsAfterResolving(newType, (PsiElement)param.getContainingFile())) continue;
                    String paramName = paramDeclarator.getNameIdentifier() != null ? paramDeclarator.getName() : "";
                    OCChangeUtil.replaceHandlingMacros(param, OCElementFactory.paramDeclarationByNameAndType(paramName, newType, declarator));
                    continue;
                }
                String newName = OCNameSuggester.suggestForType(newType, (PsiElement)declarator, createdNames).iterator().next();
                createdNames.add(newName);
                param.replace(OCElementFactory.paramDeclarationByNameAndType(newName, newType, declarator));
                continue;
            }
            OCChangeUtil.delete(param);
        }
        while (newTypesItr.hasNext()) {
            OCType type = newTypesItr.next();
            String newName = OCNameSuggester.suggestForType(type, (PsiElement)declarator, createdNames).iterator().next();
            createdNames.add(newName);
            OCChangeUtil.add(parameterList, OCElementFactory.paramDeclarationByNameAndType(newName, type, declarator));
        }
        if (newFunctionType.isConst()) {
            declarator.getParent().addAfter(OCElementFactory.create(OCTokenTypes.CONST_KEYWORD, declarator), (PsiElement)declarator);
        }
        if (newFunctionType.isVolatile()) {
            declarator.getParent().addAfter(OCElementFactory.create(OCTokenTypes.VOLATILE_KEYWORD, declarator), (PsiElement)declarator);
        }
    }

    private void removeAllModifiers(PsiElement element) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        ASTNode child = parent.getFirstChildNode();
        ArrayList<PsiElement> elemsToRemove = new ArrayList<PsiElement>();
        ArrayList<Pair> rangesToRemove = new ArrayList<Pair>();
        PsiElement rangeStart = null;
        while (child != null) {
            IElementType tt = child.getElementType();
            ASTNode nextChild = child.getTreeNext();
            if (this.myReturnTypeMode && tt == OCElementTypes.PARAMETER_LIST) break;
            if (OCTokenTypes.DECLARATOR_MODIFIERS.contains(tt)) {
                elemsToRemove.add(child.getPsi());
            } else if (tt == OCTokenTypes.LBRACKET) {
                rangeStart = child.getPsi();
            } else if (tt == OCTokenTypes.RBRACKET) {
                if (rangeStart != null) {
                    rangesToRemove.add(Pair.create((Object)rangeStart, (Object)child.getPsi()));
                }
                rangeStart = null;
            }
            child = nextChild;
        }
        for (PsiElement psiElement : elemsToRemove) {
            psiElement.delete();
        }
        for (Pair pair : rangesToRemove) {
            element.deleteChildRange((PsiElement)pair.getFirst(), (PsiElement)pair.getSecond());
        }
    }

    public static void addModifier(PsiElement element, PsiElement token) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        ASTNode child = parent.getFirstChildNode();
        while (child != null) {
            IElementType tt = child.getElementType();
            ASTNode nextChild = child.getTreeNext();
            if (tt == OCTokenTypes.IDENTIFIER) {
                CodeEditUtil.addChild(parent, token.getNode(), child);
                return;
            }
            child = nextChild;
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

