/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeGCCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private String myAttribute;
    private String myAttributeText;
    private boolean myEnable;
    private String myText;

    public OCChangeGCCAttributeIntentionAction(@Nullable OCSymbol symbol, String attribute, String attributeText, boolean enable) {
        super(symbol);
        this.myAttribute = attribute;
        this.myAttributeText = attributeText;
        this.myEnable = enable;
        if (symbol != null) {
            this.myText = (enable ? "Enable '" : "Disable '") + this.myAttributeText + "' for " + symbol.getNameWithKindLowercase();
        }
    }

    @Override
    protected boolean isAvailable(OCSymbol symbol) {
        return OCCodeInsightUtil.isValid(symbol.locateDefinition()) && this.myEnable ^ symbol.hasAttribute(this.myAttribute);
    }

    @Override
    protected String getTextInternal(OCSymbol symbol) {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Change attribute '" + this.myAttributeText + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(OCSymbol symbol) {
        final ArrayList definitions = new ArrayList();
        symbol.processSameSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                Object definition = symbol.locateDefinition();
                if (definition != null) {
                    definitions.add(definition);
                }
                return true;
            }
        });
        for (PsiElement definition : definitions) {
            this.importFileContainingAttribute(definition);
            int offset = -1;
            if (definition instanceof OCDeclarator) {
                offset = definition.getTextRange().getStartOffset();
            } else if (definition instanceof OCStructLike) {
                offset = definition.getParent().getTextRange().getEndOffset();
            } else if (definition instanceof OCMethod) {
                List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                if (!parameters.isEmpty()) {
                    offset = parameters.get(parameters.size() - 1).getTextRange().getEndOffset();
                }
            } else if (definition instanceof OCMethodSelectorPart) {
                OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
                if (typeElement != null) {
                    offset = typeElement.getTextOffset();
                }
            } else if (definition instanceof OCLabeledStatement) {
                offset = definition.getTextOffset();
            } else assert (false) : definition.getClass();
            if (offset == -1) continue;
            if (this.myEnable) {
                OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), offset, 0, " " + this.myAttributeText + " ", true);
                continue;
            }
            int index = definition.getText().indexOf(this.myAttributeText);
            if (index == -1) continue;
            OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), definition.getTextRange().getStartOffset() + index, this.myAttributeText.length(), "", true);
        }
    }

    private void importFileContainingAttribute(PsiElement definition) {
        PsiFile file2 = definition.getContainingFile();
        OCResolveContext context = new OCResolveContext((PsiElement)file2);
        context.setProcessNonImported(true);
        OCSymbolReference ref = OCSymbolReference.getGlobalReference(this.myAttributeText, null);
        List<OCSymbol> unusedSymbols = context.resolveToSymbols(ref);
        for (OCSymbol unused : unusedSymbols) {
            if (unused.getKind() == OCSymbolKind.MACRO && new OCImportSymbolFix((PsiElement)definition.getContainingFile(), unused).fixFirstItem(file2.getProject(), file2)) break;
        }
    }

    public static class SuppressFix
    extends SuppressIntentionAction {
        private OCChangeGCCAttributeIntentionAction myAction;

        public SuppressFix(OCSymbol symbol, String attribute, String attributeText, boolean enable) {
            this.myAction = new OCChangeGCCAttributeIntentionAction(symbol, attribute, attributeText, enable){

                @Override
                protected boolean isAvailable(OCSymbol symbol) {
                    return super.isAvailable(symbol) && SuppressFix.this.isAvailable(symbol);
                }
            };
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "invoke"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "invoke"));
            }
            this.myAction.invoke(project, editor, element.getContainingFile());
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "isAvailable"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "isAvailable"));
            }
            return this.myAction.isAvailable(project, editor, element.getContainingFile());
        }

        protected boolean isAvailable(OCSymbol symbol) {
            return true;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.myAction.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction$SuppressFix", "getText"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }
    }
}

