/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeElementIntentionAction
extends OCPsiElementsQuickFix {
    private String myIntentionName;
    private String myFamilyName;

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, String intentionName) {
        this(element, newElement, intentionName, intentionName);
    }

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, String intentionName, String familyName) {
        super(element, newElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    public OCChangeElementIntentionAction(PsiElement element, List<? extends PsiElement> newElements, String intentionName) {
        super(ContainerUtil.concat(Collections.singletonList(element), newElements));
        this.myIntentionName = intentionName;
        this.myFamilyName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCChangeElementIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected boolean isAvailable() {
        return OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file2) {
        List<? extends PsiElement> elements = this.getElements();
        PsiElement oldElement = elements.get(0);
        if (elements.size() == 2) {
            PsiElement newElement = elements.get(1);
            if (oldElement instanceof OCExpression && newElement instanceof OCExpression) {
                OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)oldElement, (OCExpression)newElement);
            } else {
                OCChangeUtil.replaceHandlingMacros(oldElement, newElement);
            }
        } else {
            PsiElement anchor = oldElement;
            for (int i = 1; i < elements.size(); ++i) {
                anchor = OCChangeUtil.addAfter(anchor.getParent(), elements.get(i), anchor);
            }
            OCChangeUtil.delete(oldElement);
        }
    }
}

