/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCAddElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    private String myCaption;
    private SmartPsiElementPointer myNewElementPtr;
    private String myFamilyName;

    public OCAddElementIntentionAction(String caption, PsiElement parent, PsiElement newElement) {
        this(caption, caption, parent, newElement);
    }

    public OCAddElementIntentionAction(String caption, String familyName, PsiElement parent, PsiElement newElement) {
        super(parent);
        this.myNewElementPtr = OCElementUtil.createPsiElementPointer(newElement);
        this.myCaption = caption;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myCaption;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/quickfixes/OCAddElementIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/quickfixes/OCAddElementIntentionAction", "invoke"));
        }
        OCChangeUtil.addBefore(parent, OCElementUtil.getPsiElementByPointer(this.myNewElementPtr), null);
    }
}

