/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SLRUSynchronizedCache<K, V> {
    @NotNull
    private final SLRUCache<K, NotNullLazyValue<V>> myCache;

    public SLRUSynchronizedCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUCache<K, NotNullLazyValue<V>>(protectedQueueSize, probationalQueueSize){

            @NotNull
            public NotNullLazyValue<V> createValue(final K key) {
                NotNullLazyValue notNullLazyValue = new NotNullLazyValue<V>(){

                    @NotNull
                    protected V compute() {
                        Object v = SLRUSynchronizedCache.this.createValue(key);
                        if (v == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/SLRUSynchronizedCache$1$1", "compute"));
                        }
                        return v;
                    }
                };
                if (notNullLazyValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/SLRUSynchronizedCache$1", "createValue"));
                }
                return notNullLazyValue;
            }
        };
    }

    public abstract V createValue(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public V get(K key) {
        NotNullLazyValue notNullLazyValue = this.myCache;
        // MONITORENTER : notNullLazyValue
        NotNullLazyValue value = (NotNullLazyValue)this.myCache.get(key);
        // MONITOREXIT : notNullLazyValue
        notNullLazyValue = value;
        // MONITORENTER : notNullLazyValue
        Object object = value.getValue();
        // MONITOREXIT : notNullLazyValue
        if (object != null) return (V)object;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/SLRUSynchronizedCache", "get"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V getIfCached(K key) {
        NotNullLazyValue value;
        NotNullLazyValue notNullLazyValue = this.myCache;
        synchronized (notNullLazyValue) {
            value = (NotNullLazyValue)this.myCache.getIfCached(key);
        }
        if (value == null) {
            return null;
        }
        notNullLazyValue = value;
        synchronized (notNullLazyValue) {
            return (V)value.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SLRUCache<K, NotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            this.myCache.clear();
        }
    }
}

