/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFileSymbolsContainerBase
implements Processor<OCSymbol>,
OCNamespaceLikeSymbol.FileSymbolsProvider {
    private OCFile myFile;
    protected MostlySingularMultiMap<String, OCSymbol> myNameToSymbol = new MostlySingularMultiMap();
    protected Collection<OCUsingSymbol> myUsingSymbols = new ArrayList<OCUsingSymbol>();
    protected Collection<OCNamespaceSymbol> myInlineNamespaces = new ArrayList<OCNamespaceSymbol>();
    protected HashMap<OCUsingSymbol, Integer> myAllUsingSymbolsToIndex = new HashMap();
    protected int myCurrentUsingIndex = 0;

    protected OCFileSymbolsContainerBase(OCFile file2) {
        this.myFile = file2;
    }

    @Override
    public OCFile getFile() {
        return this.myFile;
    }

    @Override
    public String getPresentableName() {
        return "File '" + this.myFile.getName() + "'";
    }

    @Override
    public OCFile getContainingOCFile() {
        return this.myFile;
    }

    @Nullable
    public PsiElement getTargetElement() {
        return this.myFile;
    }

    @Nullable
    public String getName() {
        return "Top Level Functions";
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return OCFileSymbolsContainerBase.this.getName();
            }

            @Nullable
            public String getLocationString() {
                return OCFileSymbolsContainerBase.this.myFile.getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return OCFileSymbolsContainerBase.this.myFile.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        this.myFile.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myFile.canNavigateToSource();
    }

    protected void fillUsingsIndex(OCNamespaceSymbol symbol) {
        Collection namespaceUsings = symbol.getNamespaceUsings();
        if (namespaceUsings != null) {
            for (OCUsingSymbol using : namespaceUsings) {
                this.myAllUsingSymbolsToIndex.put(using, this.myCurrentUsingIndex++);
            }
        }
        symbol.processMembers((String)null, new Processor<OCSymbol>(){

            public boolean process(OCSymbol member) {
                if (member.getKind() == OCSymbolKind.NAMESPACE) {
                    OCFileSymbolsContainerBase.this.fillUsingsIndex((OCNamespaceSymbol)member);
                }
                return true;
            }
        });
    }

    @Override
    public boolean processMembers(@Nullable String name, @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileSymbolsContainerBase", "processMembers"));
        }
        if (name != null) {
            return this.myNameToSymbol.processForKey((Object)name, processor2);
        }
        return this.myNameToSymbol.processAllValues(processor2);
    }

    @Override
    public Collection<OCUsingSymbol> getNamespaceUsings() {
        return this.myUsingSymbols;
    }

    @Override
    @Nullable
    public Collection<OCNamespaceSymbol> getInlineNamespaces() {
        return this.myInlineNamespaces;
    }

    @Override
    public int getUsingNamespaceIndex(OCUsingSymbol using) {
        Integer integer = this.myAllUsingSymbolsToIndex.get(using);
        if (integer != null) {
            return integer;
        }
        return -1;
    }
}

