/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache");
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols> myCache = new SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols>(CACHE_SIZE, CACHE_SIZE){

        @Override
        @NotNull
        public OCFileGlobalSymbols createValue(OCFile key) {
            OCFileGlobalSymbols oCFileGlobalSymbols = OCFileGlobalSymbols.buildSymbols((OCFileImpl)key);
            if (oCFileGlobalSymbols == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$1", "createValue"));
            }
            return oCFileGlobalSymbols;
        }
    };
    private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> myLightCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(20, 20){

        @Override
        @NotNull
        public OCLightFileGlobalSymbols createValue(OCFile key) {
            OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, false);
            if (oCLightFileGlobalSymbols == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$2", "createValue"));
            }
            return oCLightFileGlobalSymbols;
        }
    };
    private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> myTypesOnlyCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(150, 150){

        @Override
        @NotNull
        public OCLightFileGlobalSymbols createValue(OCFile key) {
            OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, true);
            if (oCLightFileGlobalSymbols == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$3", "createValue"));
            }
            return oCLightFileGlobalSymbols;
        }
    };
    private long myModCount = -1L;

    public static OCFileGlobalSymbolsCache getInstance(Project project) {
        return (OCFileGlobalSymbolsCache)project.getComponent(OCFileGlobalSymbolsCache.class);
    }

    public OCFileGlobalSymbols forFile(OCFile file2) {
        return this.myCache.get(file2);
    }

    public OCNamespaceLikeSymbol lightTableForFile(OCFile file2) {
        OCFileGlobalSymbols symbols = this.myCache.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        return this.myLightCache.get(file2);
    }

    public OCNamespaceLikeSymbol typesOnlyTableForFile(OCFile file2) {
        OCFileGlobalSymbols symbols = this.myCache.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        OCLightFileGlobalSymbols lSymbols = this.myLightCache.getIfCached(file2);
        if (lSymbols != null) {
            return lSymbols;
        }
        return this.myTypesOnlyCache.get(file2);
    }

    public void clear() {
        this.myCache.clear();
        this.myLightCache.clear();
        this.myTypesOnlyCache.clear();
    }

    public OCFileGlobalSymbolsCache(MessageBus bus, PsiManager psiManager) {
        final PsiModificationTracker tracker = psiManager.getModificationTracker();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                long current = tracker.getOutOfCodeBlockModificationCount();
                if (OCFileGlobalSymbolsCache.this.myModCount != current) {
                    OCFileGlobalSymbolsCache.this.myModCount = current;
                    OCFileGlobalSymbolsCache.this.clear();
                }
            }
        });
    }

    public static void processFile(OCFileImpl file2, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (!OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    public static boolean processFileImpl(@NotNull OCFileImpl file2, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable table;
        FileSymbolTable tableForPch;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache", "processFileImpl"));
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(file2.getProject())) {
            return true;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        THashSet processed = new THashSet();
        OCFile pch = null;
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file2);
        PsiFile importHolder = context.getRootFile();
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            OCLanguageKind contextKind = context.getLanguageKind();
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, contextKind, importHolder);
            pch = precompiledContext.getPrecompiledHeader();
            initial = OCInclusionContext.beforePCHFileContext(configuration, contextKind, importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file2);
        }
        boolean contextWasProcessed = false;
        if (pch != null && (tableForPch = FileSymbolTable.forFile(pch, initial)) != null) {
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, OCElementUtil.getFilePath(pch), initial, null);
            } else {
                tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, OCElementUtil.getFilePath(pch), initial, virtualFile);
                contextWasProcessed = true;
            }
        }
        if (!contextWasProcessed && file2.isHeader() && (table = FileSymbolTable.forFile(importHolder, initial)) != null) {
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, null, initial, file2.getVirtualFile());
            if (initial.isProcessed(OCInclusionContextUtil.getVirtualFile(file2))) {
                return false;
            }
        }
        if ((table = file2.getSymbolTable(initial)) != null) {
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, null, initial, null);
        }
        return true;
    }
}

