/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnaryExpressionImpl
extends OCExpressionBase
implements OCUnaryExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCUnaryExpressionImpl");

    public OCUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCOperatorReference getReference() {
        TextRange range = OCElementUtil.getRangeInParent(this.getOperationSignNode());
        String name = this.getOperationSign().getName();
        OCExpression operand = this.getOperand();
        if (operand != null) {
            return new OCOperatorReference((OCElement)this, name, range, operand);
        }
        return null;
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getOperationSign"));
        }
        return oCElementType;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        ASTNode aSTNode = this.getNode().getFirstChildNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getOperationSignNode"));
        }
        return aSTNode;
    }

    @Override
    public boolean isGetAddress() {
        return this.getOperationSign() == OCTokenTypes.AND;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "accept"));
        }
        visitor.visitUnaryExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getType"));
        }
        OCOperatorReference reference = this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols()) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = operator.getEffectiveType();
                if (oCType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getType"));
                }
                return oCType;
            }
        }
        OCElementType sign = this.getOperationSign();
        OCExpression op = this.getOperand();
        if (op == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getType"));
            }
            return oCUnknownType;
        }
        OCType opType = op.getResolvedType(context);
        OCType oCType = OCUnaryExpressionImpl.getUnaryExprType(sign, opType, this);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl", "getType"));
        }
        return oCType;
    }

    public static OCType getUnaryExprType(OCElementType sign, OCType opType, @Nullable PsiElement context) {
        OCType result2;
        if (opType.isSubclassOfMagic(context)) {
            result2 = OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.MUL) {
            result2 = opType instanceof OCPointerType ? ((OCPointerType)opType).getRefType() : OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.__REAL__KEYWORD || sign == OCTokenTypes.__IMAG__KEYWORD) {
            result2 = opType instanceof OCRealType ? ((OCRealType)opType).cloneWithoutComplexModifier() : opType;
        } else if (sign == OCTokenTypes.AND) {
            OCType type = opType;
            if (type instanceof OCCppReferenceType) {
                type = ((OCCppReferenceType)type).getRefType();
            }
            result2 = OCPointerType.to(type, null);
        } else if (sign == OCTokenTypes.TILDE || sign == OCTokenTypes.PLUS) {
            result2 = opType;
        } else if (sign == OCTokenTypes.MINUS) {
            result2 = opType instanceof OCIntType ? ((OCIntType)opType).promoteToSigned() : opType;
        } else if (sign == OCTokenTypes.EXCL) {
            result2 = OCIntType.getAppropriateBool((OCElement)context);
        } else {
            LOG.error("Unknown operation sign");
            result2 = OCUnknownType.INSTANCE;
        }
        if (result2 instanceof OCNumericType) {
            result2 = result2.cloneWithoutCVQualifiers(context != null ? context.getProject() : null);
        }
        return result2;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getOperand());
    }
}

