/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertyAttributeImpl
extends OCElementBase
implements OCPropertyAttribute {
    public OCPropertyAttributeImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl", "accept"));
        }
        visitor.visitPropertyAttribute(this);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement ident = this.getNameIdentifier();
        String string = ident == null ? "<unnamed>" : ident.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl", "setName"));
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public PsiElement getValueElement() {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        return names.size() == 2 ? (PsiElement)names.get(1) : null;
    }

    @Override
    @Nullable
    public String getValue() {
        PsiElement element = this.getValueElement();
        if (element == null) {
            return null;
        }
        String result2 = element.getText();
        return this.getName().equals("setter") && !result2.endsWith(":") ? result2 + ":" : result2;
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(OCTokenTypes.COLON);
    }

    @Override
    @Nullable
    public OCProperty getParentProperty() {
        PsiElement property;
        PsiElement list = this.getParent();
        if (list instanceof OCPropertyAttributesList && (property = list.getParent()) instanceof OCProperty) {
            return (OCProperty)property;
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        if (names.size() == 2) {
            ((PsiElement)names.get(1)).replace(OCElementFactory.createIdentifier(value, this));
        }
    }

    @Override
    public PsiReference getReference() {
        PsiElement valueElement = this.getValueElement();
        String keyName = this.getName();
        if ((keyName.equals("getter") || keyName.equals("setter")) && valueElement != null) {
            return new AccessorMethodReference();
        }
        return super.getReference();
    }

    private class AccessorMethodReference
    implements OCReference {
        private AccessorMethodReference() {
        }

        @Override
        public OCSymbol resolveToSymbol() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol symbol) {
                    if (!symbol.isStatic()) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (classSymbol != null) {
                classSymbol.processMembers(this.getCanonicalText(), OCMethodSymbol.class, finder);
            }
            return (OCSymbol)finder.getFoundValue();
        }

        @Nullable
        private OCImplementationSymbol getClassSymbol() {
            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), OCClassDeclaration.class);
            if (classDeclaration == null) {
                return null;
            }
            OCClassSymbol classSymbol = classDeclaration.getSymbol();
            if (classSymbol == null) {
                return null;
            }
            return classSymbol.getImplementation();
        }

        public PsiElement getElement() {
            return OCPropertyAttributeImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCElementUtil.getRangeInParent(OCPropertyAttributeImpl.this.getValueElement());
        }

        public PsiElement resolve() {
            OCSymbol symbol = this.resolveToSymbol();
            return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCPropertyAttributeImpl.this.getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (!OCPropertyAttributeImpl.this.getName().equals(newElementName)) {
                return OCPropertyAttributeImpl.this.getValueElement().replace(OCElementFactory.createIdentifier(newElementName, OCPropertyAttributeImpl.this));
            }
            return this.getElement();
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference", "bindToSymbol"));
            }
            assert (symbol instanceof OCMethodSymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference", "bindToElement"));
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            OCSymbol refSymbol = this.resolveToSymbol();
            return symbol instanceof OCMethodSymbol && (Comparing.equal((Object)refSymbol, symbol) || Comparing.equal((Object)refSymbol, (Object)((OCMethodSymbol)symbol).getAssociatedSymbol()));
        }

        @NotNull
        public Object[] getVariants() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            final boolean isSetter = OCPropertyAttributeImpl.this.getName().equals("setter");
            final ArrayList result2 = new ArrayList();
            if (classSymbol != null) {
                classSymbol.processMembers(null, OCMethodSymbol.class, new Processor<OCMethodSymbol>(){

                    public boolean process(OCMethodSymbol symbol) {
                        if (symbol.isGetter() && !isSetter || symbol.isSetter() && isSetter) {
                            result2.add(SymbolLookupBuilderUtil.lookup(symbol).withInsertHandler(new BasicInsertHandler()));
                        }
                        return true;
                    }
                });
            }
            Object[] objectArray = result2.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isSoft() {
            return false;
        }
    }
}

