/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterListImpl
extends OCElementBase
implements OCParameterList {
    public OCParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCParameterListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public List<OCParameterDeclaration> getParameterDeclarations() {
        List<OCParameterDeclaration> list = this.findChildrenByType(OCElementTypes.PARAMETER_DECLARATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCParameterListImpl", "getParameterDeclarations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCDeclarator> getParameters() {
        ArrayList<OCDeclarator> result2 = new ArrayList<OCDeclarator>();
        for (OCParameterDeclaration declaration : this.getParameterDeclarations()) {
            OCDeclarator declarator = declaration.getDeclarator();
            if (declarator == null) continue;
            result2.add(declarator);
        }
        ArrayList<OCDeclarator> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCParameterListImpl", "getParameters"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public ASTNode getLParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
    }

    @Override
    @Nullable
    public ASTNode getRParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.RPAR);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCParameterListImpl", "accept"));
        }
        visitor.visitParameterList(this);
    }
}

