/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSelectorPartImpl
extends OCElementBase
implements OCMethodSelectorPart {
    public OCMethodSelectorPartImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public String getSelectorPart() {
        StringBuilder builder = new StringBuilder();
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            builder.append(child.getText());
            child = child.getTreeNext();
        }
        while (child != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(child.getElementType())) {
            child = child.getTreeNext();
        }
        if (child != null && child.getElementType() == OCTokenTypes.COLON) {
            builder.append(child.getText());
        }
        return builder.toString();
    }

    @Override
    public String getParameterName() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getText() : null;
    }

    @Override
    public String getName() {
        return this.getParameterName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl", "setName"));
        }
        ASTNode parameterNode = this.findParameterNode();
        if (parameterNode != null) {
            CodeEditUtil.replaceChild(this.getNode(), parameterNode, OCElementFactory.createIdentifier(name, this).getNode());
        }
        return this;
    }

    @Override
    @Nullable
    public PsiElement getSelectorIdentifier() {
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            return child.getPsi();
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode paramNode = this.findParameterNode();
        return paramNode != null ? paramNode.getPsi() : null;
    }

    @Override
    public PsiElement getParameter() {
        Object last;
        PsiElement first = this.getFirstChild();
        if (first != (last = this.findLastChildByType(OCTokenTypes.IDENTIFIER)) && last != null) {
            return last;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findParameterNode() {
        PsiElement parameter = this.getParameter();
        return parameter != null ? parameter.getNode() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getStartOffset() : super.getTextOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement id = this.getParameter();
        return id != null ? OCSymbolOffsetUtil.getComplexOffset(id) : super.getComplexOffset();
    }

    @Override
    @NotNull
    public OCType getType() {
        OCTypeElement typeElement = this.getTypeElement();
        OCType oCType = typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl", "getType"));
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getRawType() {
        OCTypeElement typeElement = this.getTypeElement();
        OCType oCType = typeElement != null ? typeElement.getRawType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl", "getRawType"));
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCDeclaratorSymbol getLocalSymbol() {
        OCFile file2 = this.getContainingOCFile();
        OCMethod method = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMethod.class});
        TextRange scope = null;
        if (method != null) {
            OCBlockStatement body = method.getBody();
            scope = body != null ? body.getTextRange() : method.getTextRange();
        }
        ASTNode selectorNode = this.getNode();
        OCLanguageKind kind = file2.getKind();
        OCBuilderDriver<ASTNode> driver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(kind, file2), new ASTStructure(selectorNode), OCBuilderDriver.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)CommonProcessors.alwaysTrue());
        OCMethodSymbol.SelectorPartSymbol selector = driver.processSelectorPart(selectorNode, new StringBuilder(), scope, (Ref<Long>)new Ref(), null);
        if (selector != null) {
            OCDeclaratorSymbol parameter = selector.getParameter();
            if (parameter != null && method != null) {
                parameter.setParentMethod((OCMethodSymbol)method.getSymbol());
            }
            return parameter;
        }
        return null;
    }

    @Override
    public OCDeclaratorSymbol getSymbol() {
        return this.getLocalSymbol();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCMethodSelectorPartImpl", "accept"));
        }
        visitor.visitMethodSelectorPart(this);
    }
}

