/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCLocalizedStringImpl
extends ASTWrapperPsiElement
implements OCLocalizedString {
    public OCLocalizedStringImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.getLiteralValue(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "getKey"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getValue() {
        String string = this.getLiteralValue(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "getValue"));
        }
        return string;
    }

    @Override
    public String getName() {
        return this.getKey();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "setName"));
        }
        PsiElement literal = this.getFirstChild();
        if (literal != null) {
            OCChangeUtil.changeText(this.getProject(), this.getContainingFile(), literal.getTextOffset() + 1, literal.getTextLength() - 2, name, false, false);
        }
        return this;
    }

    @Override
    public OCLocalizedStringSymbol getSymbol() {
        return new OCLocalizedStringSymbol(this.getProject(), this.getContainingFile().getVirtualFile(), this.getTextOffset(), this.getName(), Collections.<String>emptyList());
    }

    @NotNull
    private String getLiteralValue(int literalIndex) {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type != OCTokenTypes.STRING_LITERAL && type != OCTokenTypes.IDENTIFIER || literalIndex-- != 0) continue;
            String string = type == OCTokenTypes.STRING_LITERAL ? StringUtil.unquoteString((String)child.getText()) : child.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "getLiteralValue"));
            }
            return string;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl", "getLiteralValue"));
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public Icon getIcon(boolean open2) {
                return null;
            }

            public String getPresentableText() {
                return OCLocalizedStringImpl.this.getValue();
            }

            public String getLocationString() {
                return ((OCStringsFile)OCLocalizedStringImpl.this.getContainingFile()).getLocalizationName();
            }
        };
    }
}

