/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionImpl
extends OCExpressionBase
implements OCLambdaExpression {
    public OCLambdaExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.LAMBDA;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCTypeElement typeElement = this.getReturnTypeElement();
        OCType oCType = typeElement != null ? typeElement.getType() : OCExpectedTypeUtil.getReturnTypeOfLambda(this.getBody());
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "getReturnType"));
        }
        return oCType;
    }

    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return (OCNoexceptSpecifier)this.findChildByType(OCElementTypes.CPP_NOEXCEPT_SPECIFIER);
    }

    @Override
    public OCSymbol getSymbol() {
        return new OCLambdaSymbol(this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "setName"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public OCLambdaIntroducer getLambdaIntroducer() {
        OCLambdaIntroducer oCLambdaIntroducer = (OCLambdaIntroducer)this.findChildByType(OCElementTypes.CPP_LAMBDA_INTRODUCER);
        if (oCLambdaIntroducer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "getLambdaIntroducer"));
        }
        return oCLambdaIntroducer;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "getType"));
        }
        OCParameterList params = this.getParameterList();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (params != null) {
            for (OCParameterDeclaration parameterDeclaration : params.getParameterDeclarations()) {
                OCDeclarator paramDeclarator = parameterDeclaration.getDeclarator();
                if (paramDeclarator == null) continue;
                paramTypes.add(paramDeclarator.getType());
                paramNames.add(paramDeclarator.getName());
            }
        }
        OCPointerType oCPointerType = OCPointerType.to(new OCFunctionType(this.getReturnType(), paramTypes, paramNames));
        if (oCPointerType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "getType"));
        }
        return oCPointerType;
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType(OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl", "accept"));
        }
        visitor.visitLambdaExpression(this);
    }

    public static class OCLambdaSymbol
    extends OCSymbolImpl {
        public OCLambdaSymbol() {
        }

        public OCLambdaSymbol(OCLambdaExpression expr) {
            super(expr.getProject(), expr.getContainingFile().getVirtualFile(), expr.getTextOffset(), OCLambdaSymbol.calcName(expr), Collections.<String>emptyList());
        }

        private static String calcName(OCLambdaExpression expr) {
            StringBuilder result2 = new StringBuilder();
            result2.append("[");
            OCLambdaIntroducer introducer = expr.getLambdaIntroducer();
            if (introducer.getCaptureDefault() != null) {
                result2.append(introducer.getCaptureDefault());
            }
            if (!introducer.getReferencedElements().isEmpty()) {
                result2.append("...");
            }
            result2.append("]");
            if (expr.getReturnTypeElement() != null) {
                result2.append(expr.getReturnTypeElement().getText());
            }
            result2.append("{...}");
            return result2.toString();
        }

        @Override
        @NotNull
        public OCSymbolKind getKind() {
            OCSymbolKind oCSymbolKind = OCSymbolKind.LAMBDA;
            if (oCSymbolKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCLambdaExpressionImpl$OCLambdaSymbol", "getKind"));
            }
            return oCSymbolKind;
        }
    }
}

