/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLabeledStatementImpl
extends OCElementBase
implements OCLabeledStatement {
    public OCLabeledStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCLabeledStatementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public String getLabel() {
        Object child = this.findChildByType(OCTokenTypes.IDENTIFIER);
        return child != null ? child.getText() : "";
    }

    @Override
    @Nullable
    public PsiElement getLabelElement() {
        return this.getNode().getFirstChildNode().getPsi();
    }

    @Override
    public OCStatement getStatement() {
        return (OCStatement)this.findChildByType(OCElementTypes.STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCLabeledStatementImpl", "accept"));
        }
        visitor.visitLabeledStatement(this);
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public String getName() {
        return this.getLabel();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCLabeledStatementImpl", "setName"));
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public OCLabelSymbol getLocalSymbol() {
        OCFile file2 = this.getContainingOCFile();
        OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCCallable.class});
        ArrayList<String> attributesList = new ArrayList<String>();
        for (PsiElement attributes : this.findChildrenByType(OCElementTypes.ATTRIBUTES)) {
            ASTNode attributesNode = attributes.getNode().getTreeParent();
            OCLanguageKind kind = file2.getKind();
            OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(kind, file2), new ASTStructure(attributesNode), OCBuilderDriver.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)CommonProcessors.alwaysTrue());
            attributesList.addAll(builderDriver.processAttributeList(attributesNode));
        }
        attributesList.trimToSize();
        return new OCLabelSymbol(file2.getProject(), OCInclusionContextUtil.getVirtualFile(file2), this.getTextOffset(), this.getName(), callable != null && callable.getBody() != null ? callable.getBody().getTextRange() : null, attributesList);
    }

    @Override
    public OCLabelSymbol getSymbol() {
        return this.getLocalSymbol();
    }
}

