/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveLanguageAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileImpl
extends PsiFileBase
implements OCFile {
    private static final Logger LOG = Logger.getInstance(OCFileImpl.class);
    private int myAnnotationSessionDepthsCounter = 0;
    private AnnotationSession myCurrentAnnotationSession = null;
    private final Object myAnnotationSessionLock = new Object();
    private final Set<OCFile> myIncludedFrom = new THashSet();
    private volatile OCLanguageKind myFileKind;
    private volatile FileSymbolTable mySymbolTable;
    private OCResolveLanguageAndConfiguration myParsedResolveLanguageAndConfiguration;

    public OCFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, OCLanguage.getInstance());
    }

    @NotNull
    public FileType getFileType() {
        OCFileType oCFileType = OCFileType.INSTANCE;
        if (oCFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "getFileType"));
        }
        return oCFileType;
    }

    @Override
    public boolean isHeader() {
        return OCFileImpl.isHeaderFile(this.getName());
    }

    @Override
    public boolean isStlLikeHeader() {
        return FileUtilRt.getExtension((String)this.getName()).isEmpty();
    }

    public static boolean isHeaderFile(String fileName) {
        return OCFileTypeHelpers.isHeaderFile(fileName);
    }

    public static boolean isSourceCodeFile(String fileName) {
        return OCFileTypeHelpers.isSourceFile(fileName);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFile() {
        class StopException
        extends RuntimeException {
            StopException() {
            }
        }
        final String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)this.getName());
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        final OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{new Condition<OCFile>(){

            public boolean value(OCFile file2) {
                return FileUtil.getNameWithoutExtension((String)file2.getName()).equals(nameWithoutExtension);
            }
        }, Conditions.alwaysTrue()});
        try {
            this.accept(new OCRecursiveVisitor(){

                @Override
                public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                @Override
                public void visitFunctionDefinition(OCFunctionDefinition definition) {
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                @Override
                public void visitClassDeclaration(OCClassDeclaration dcl) {
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private void processSymbol(OCSymbol symbol) {
                    if (symbol != null) {
                        symbol.processSameSymbols(new Processor<OCSymbol>(){

                            public boolean process(OCSymbol symbol) {
                                OCFile file2 = symbol.getContainingOCFile();
                                if (file2 != null && file2.isHeader() != OCFileImpl.this.isHeader() && !processor2.process(file2)) {
                                    throw new StopException();
                                }
                                return true;
                            }
                        });
                    }
                }
            });
        }
        catch (StopException stopException) {
            // empty catch block
        }
        processor2.finish();
        if (finder.isFound()) {
            return (OCFile)finder.getFoundValue();
        }
        return this.getAssociatedFileWithSameName();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFileWithSameName() {
        final OCWorkspace workspace = OCWorkspaceManager.getWorkspace(this.getProject());
        final VirtualFile virtualFile = this.getVirtualFile();
        HashSet<String> associatedExts = new HashSet<String>(this.isHeader() ? OCFileTypeHelpers.SOURCE_FILE_EXTENSIONS : OCFileTypeHelpers.HEADER_FILE_EXTENSIONS);
        associatedExts.remove("pch");
        for (String ext : associatedExts) {
            String associatedName = FileUtil.getNameWithoutExtension((String)this.getName()) + "." + ext;
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            final OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{new Condition<VirtualFile>(){

                public boolean value(VirtualFile curFile) {
                    return curFile == null || virtualFile == null || Comparing.equal((Object)virtualFile.getParent(), (Object)curFile.getParent());
                }
            }, new Condition<VirtualFile>(){

                public boolean value(VirtualFile each) {
                    return workspace.areFromSameProject(virtualFile, each);
                }
            }, Conditions.alwaysTrue()});
            ContainerUtil.process(OCSearchUtil.getProjectVirtualFilesByName(this.getProject(), associatedName), (Processor)new Processor<VirtualFile>(){

                public boolean process(VirtualFile file2) {
                    return !file2.isValid() || processor2.process(file2);
                }
            });
            processor2.finish();
            if (!finder.isFound()) continue;
            PsiFile file2 = PsiManager.getInstance((Project)this.getProject()).findFile((VirtualFile)finder.getFoundValue());
            return file2 instanceof OCFile ? (OCFile)file2 : null;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this.calcFileKind().isCpp();
    }

    @Override
    @NotNull
    public OCLanguageKind getKind() {
        OCLanguageKind oCLanguageKind = this.calcFileKind();
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "getKind"));
        }
        return oCLanguageKind;
    }

    @NotNull
    private OCLanguageKind calcFileKind() {
        if (this.myFileKind == null) {
            OCLanguageKind kind;
            this.myFileKind = kind = OCLanguageKindCalculator.calculateLanguageKind(this);
        }
        OCLanguageKind oCLanguageKind = this.myFileKind;
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "calcFileKind"));
        }
        return oCLanguageKind;
    }

    @Override
    public void clearCaches() {
        this.myFileKind = null;
        this.mySymbolTable = null;
        super.clearCaches();
    }

    @Override
    public boolean isInProjectSources() {
        return OCSearchScope.isInProjectSources(this);
    }

    @Override
    public boolean isInProjectSourcesOrLibraries() {
        return OCSearchScope.isInProjectSourcesOrLibraries(this);
    }

    @Override
    public boolean isInLibraries() {
        return OCSearchScope.isInLibraries(this);
    }

    @Override
    public boolean processSymbolsRecursively(@NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "processSymbolsRecursively"));
        }
        return this.processSymbolsRecursively(null, processor2);
    }

    public boolean processSymbolsRecursively(@Nullable OCImmutableInclusionContext inclusionContext, final @NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "processSymbolsRecursively"));
        }
        PsiElement context = this.getContext();
        if (context instanceof OCElement && !((OCElement)context).getContainingOCFile().processSymbolsRecursively(processor2)) {
            return false;
        }
        FileSymbolTable table = this.getSymbolTable(inclusionContext == null ? null : inclusionContext.derive());
        return table == null || table.shallowProcessSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!processor2.process((Object)symbol)) {
                    return false;
                }
                if (symbol instanceof OCMembersContainer) {
                    return ((OCMembersContainer)((Object)symbol)).processMembers(null, this);
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull OCElement element, @NotNull Class<T> symbolClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "findSymbol"));
        }
        if (symbolClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolClass", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "findSymbol"));
        }
        PsiElement context = this.getContext();
        if (context instanceof OCElement) {
            return ((OCElement)context).getContainingOCFile().findSymbol(element, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(element, symbolClass) : null;
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String name, Class<T> symbolClass) {
        PsiElement context = this.getContext();
        if (context instanceof OCElement) {
            return ((OCElement)context).getContainingOCFile().findSymbol(name, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(name, symbolClass) : null;
    }

    @Nullable
    public FileSymbolTable getSymbolTable(@Nullable OCInclusionContext context) {
        if (context != null) {
            return FileSymbolTable.forFile(this, context);
        }
        FileSymbolTable result2 = this.mySymbolTable;
        if (result2 == null) {
            this.mySymbolTable = result2 = FileSymbolTable.forFile(this, OCInclusionContextUtil.headerContext(this).derive());
        }
        return result2;
    }

    @Override
    @NotNull
    public OCNamespaceLikeSymbol getMembersContainer(boolean onlyTypes) {
        OCFileGlobalSymbolsCache cache = OCFileGlobalSymbolsCache.getInstance(this.getProject());
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = onlyTypes ? cache.typesOnlyTableForFile(this) : cache.lightTableForFile(this);
        if (oCNamespaceLikeSymbol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "getMembersContainer"));
        }
        return oCNamespaceLikeSymbol;
    }

    @Override
    @Nullable
    public OCSymbol getSameNamedClass() {
        final String name = this.getMainClassName();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isInnerClass()) && name.equals(symbol.getName());
            }
        };
        this.processSymbolsRecursively((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public String getMainClassName() {
        int minus;
        String name = FileUtil.getNameWithoutExtension((String)this.getName());
        int plus = name.indexOf(43);
        if (plus != -1) {
            name = name.substring(0, plus);
        }
        if ((minus = name.indexOf(45)) != -1) {
            name = name.substring(0, minus);
        }
        return name;
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findFirstClass() {
        return this.findClass(null);
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findClass(final String name) {
        final Ref result2 = new Ref();
        this.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (!(dcl instanceof OCClassPredeclaration) && result2.isNull() && (name == null || name.equals(dcl.getCanonicalName()))) {
                    result2.set((Object)dcl);
                }
                super.visitClassDeclaration(dcl);
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (result2.isNull() && (name == null || name.equals(struct.getName()))) {
                    result2.set((Object)struct);
                }
                super.visitStruct(struct);
            }
        });
        return (OCSymbolDeclarator)result2.get();
    }

    @Override
    public List<OCIncludeDirective> findIncludeDirectives() {
        final ArrayList<OCIncludeDirective> answer = new ArrayList<OCIncludeDirective>();
        this.acceptChildren(new OCRecursiveVisitor(){

            @Override
            public void visitImportDirective(OCIncludeDirective directive) {
                answer.add(directive);
            }
        });
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushAnnotationSession(AnnotationSession session) {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = session;
            }
            ++this.myAnnotationSessionDepthsCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popAnnotationSession() {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            --this.myAnnotationSessionDepthsCounter;
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = null;
            }
        }
    }

    @Override
    @Nullable
    public AnnotationSession getCurrentAnnotationSession() {
        return this.myCurrentAnnotationSession;
    }

    @Override
    @NotNull
    public Object getAnnotationSessionLock() {
        Object object = this.myAnnotationSessionLock;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "getAnnotationSessionLock"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIncludedFrom(OCFile from) {
        if (from != null) {
            Set<OCFile> set = this.myIncludedFrom;
            synchronized (set) {
                this.myIncludedFrom.add(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OCFile> resetIncludingFiles() {
        Set<OCFile> set = this.myIncludedFrom;
        synchronized (set) {
            ArrayList<OCFile> answer = new ArrayList<OCFile>(this.myIncludedFrom);
            this.myIncludedFrom.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OCFile> getIncludingFiles() {
        Set<OCFile> set = this.myIncludedFrom;
        synchronized (set) {
            return new ArrayList<OCFile>(this.myIncludedFrom);
        }
    }

    @Override
    @Nullable
    public OCIncludeDirective findIncludeDirective(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        for (PsiElement child : this.getChildren()) {
            OCIncludeDirective directive;
            PsiFile importedFile;
            if (!(child instanceof OCIncludeDirective) || !Comparing.equal((Object)file2, (Object)OCElementUtil.getFilePath(importedFile = (directive = (OCIncludeDirective)child).getIncludedFile()))) continue;
            return directive;
        }
        return null;
    }

    @Override
    public String toString() {
        return "OCFile:" + this.getName();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "accept"));
        }
        if (visitor instanceof OCVisitor) {
            ((OCVisitor)visitor).visitOCFile(this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCFileImpl", "getRangeWithMacros"));
        }
        return textRange;
    }

    @Override
    public OCFile getContainingOCFile() {
        return this;
    }

    @Override
    public String getTextWithMacros() {
        return this.getText();
    }

    @Override
    public boolean isEmpty() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof OCDefineDirective || child instanceof OCMacroCall) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getComplexOffset() {
        return this.getTextOffset();
    }

    @Override
    public boolean hasExtraTopLevelDefinitions() {
        OCSymbol mainClass = this.getSameNamedClass();
        if (mainClass == null) {
            return false;
        }
        for (PsiElement child : this.getChildren()) {
            OCType type;
            if (child instanceof OCClassDeclaration && ((OCClassDeclaration)child).getSymbol() != mainClass) {
                return true;
            }
            if (!(child instanceof OCDeclaration) || (type = ((OCDeclaration)child).getType()) instanceof OCStructType && ((OCStructType)type).getSymbol().equals(mainClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public OCResolveLanguageAndConfiguration getParsedResolveLanguageAndConfiguration() {
        return this.myParsedResolveLanguageAndConfiguration;
    }

    public void setParsedResolveLanguageAndConfiguration(@Nullable OCResolveLanguageAndConfiguration languageAndConfiguration) {
        this.myParsedResolveLanguageAndConfiguration = languageAndConfiguration;
    }
}

