/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNewExpressionImpl
extends OCExpressionBase
implements OCCppNewExpression {
    public OCCppNewExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getType"));
        }
        OCTypeElement type = this.findChildByClass(OCTypeElement.class);
        OCType oCType = type != null ? OCCppNewExpressionImpl.getNewExprType(type.getType(), type.getArrayLengths()) : super.getType(context);
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getType"));
        }
        return oCType;
    }

    @NotNull
    public static OCType getNewExprType(@NotNull OCType type, int arrayLengths) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getNewExprType"));
        }
        for (int i = 0; i < arrayLengths && type instanceof OCPointerType; ++i) {
            type = ((OCPointerType)type).getRefType();
        }
        OCPointerType oCPointerType = OCPointerType.to(type);
        if (oCPointerType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getNewExprType"));
        }
        return oCPointerType;
    }

    @Override
    @Nullable
    public OCTypeElement getConstructingTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCReferenceElement getReferenceElement() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        ASTNode node = typeElement != null ? typeElement.getNode().findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT) : null;
        return node != null ? (OCReferenceElement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public OCType getConstructingType() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        OCType oCType = typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
        if (oCType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getConstructingType"));
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        OCTypeElement typeElement = this.getConstructingTypeElement();
        for (PsiElement child = this.getLastChild(); child != null && child != typeElement; child = child.getPrevSibling()) {
            if (!(child instanceof OCArgumentList)) continue;
            return (OCArgumentList)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        OCArgumentList argumentList = this.getArgumentList();
        List<OCExpression> list = argumentList != null ? argumentList.getArguments() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getArguments"));
        }
        return list;
    }

    public OCCompoundInitializer getInitializerList() {
        OCCompoundInitializer initializer = (OCCompoundInitializer)this.findChildByType(OCElementTypes.COMPOUND_INITIALIZER);
        if (initializer != null) {
            return initializer;
        }
        OCTypeElement typeElement = this.getConstructingTypeElement();
        if (typeElement != null) {
            for (PsiElement child = typeElement.getLastChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof OCCompoundInitializer)) continue;
                return (OCCompoundInitializer)child;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializers() {
        OCArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            List<OCExpression> list = argumentList.getArguments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getInitializers"));
            }
            return list;
        }
        OCCompoundInitializer initializerList = this.getInitializerList();
        List<OCExpression> list = initializerList != null ? Collections.singletonList(initializerList) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getInitializers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCType> getInitializerTypes(final @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getInitializerTypes"));
        }
        List list = ContainerUtil.map(this.getInitializers(), (Function)new Function<OCExpression, OCType>(){

            public OCType fun(OCExpression expression) {
                return expression.getResolvedType(context);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "getInitializerTypes"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCCppNewExpressionImpl", "accept"));
        }
        visitor.visitCppNewExpression(this);
    }
}

