/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNamespaceQualifierImpl
extends OCElementBase
implements OCCppNamespaceQualifier {
    public OCCppNamespaceQualifierImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType(OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findReferenceToken();
    }

    public TextRange getRangeInElement() {
        PsiElement referenceToken = this.findReferenceToken();
        if (referenceToken != null) {
            return TextRange.from((int)referenceToken.getStartOffsetInParent(), (int)referenceToken.getTextLength());
        }
        return TextRange.EMPTY_RANGE;
    }

    @Override
    @Nullable
    public OCTemplateArgumentList getTemplateArgumentList() {
        return (OCTemplateArgumentList)this.findChildByType(OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    @Nullable
    private PsiElement findReferenceToken() {
        return this.findChildByType(OCTokenTypes.POSSIBLE_CPP_NAMES);
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "setName"));
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "accept"));
        }
        visitor.visitNamespaceQualifier(this);
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean ignoreImports) {
        List<OCSymbol> list = this.resolveToSymbols(ignoreImports, new OCResolveContext(this));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "resolveToSymbols"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean ignoreImports, @NotNull OCResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "resolveToSymbols"));
        }
        final ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        OCCommonProcessors.OrderedProcessor<OCSymbol> processor2 = new OCCommonProcessors.OrderedProcessor<OCSymbol>(new Processor<OCSymbol>(){

            public boolean process(OCSymbol ocSymbol) {
                if (ocSymbol instanceof OCNamespaceSymbol) {
                    if (ocSymbol.isPredeclaration()) {
                        if (result2.size() == 0) {
                            result2.add(ocSymbol);
                        }
                    } else {
                        result2.add(ocSymbol);
                    }
                }
                if (ocSymbol instanceof OCNamespaceAliasSymbol) {
                    if (result2.size() == 0) {
                        result2.add(ocSymbol);
                    }
                } else if (ocSymbol instanceof OCTypeParameterSymbol || ocSymbol instanceof OCDeclaratorSymbol || ocSymbol instanceof OCAliasUsingSymbol) {
                    result2.add(ocSymbol);
                }
                return true;
            }
        }, OCSymbol.NON_PREDIFINITION_CONDITION, Conditions.alwaysTrue());
        PsiElement parent = this.getParent();
        while (parent instanceof OCCppNamespaceQualifier) {
            parent = parent.getParent();
        }
        OCSymbolReference ref = OCSymbolReference.getLocalReference(this, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
        List<OCSymbol> symbols = ref.resolveToSymbols(false, true, true, context);
        ContainerUtil.process(symbols, processor2);
        processor2.finish();
        if (result2.isEmpty() && (ignoreImports || this.getContainingOCFile().isInLibraries())) {
            OCResolveContext context2 = new OCResolveContext(this.getContainingOCFile());
            context2.setProcessNonImported(true);
            ContainerUtil.process(context2.resolveToSymbols(ref, false, true), processor2);
            processor2.finish();
        }
        ArrayList<OCSymbol> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl", "resolveToSymbols"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public OCSymbol getPredeclarationInParent(OCSymbolWithQualifiedName symbol, final boolean checkTypes) {
        PsiFile file2 = this.getContainingFile();
        OCType resolvedType = symbol.getResolvedType();
        final OCTypeEqualityAfterResolvingVisitor stongEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, false, true, false, true, file2);
        final OCTypeEqualityAfterResolvingVisitor weakEqualer = new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, true, true, false, true, file2);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return !OCSymbolWithQualifiedName.isFriend(symbol);
            }
        };
        OCCommonProcessors.OrderedProcessor<OCSymbol> processor2 = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)finder, (Condition<T>[])new Condition[]{new Condition<OCSymbol>(){

            public boolean value(OCSymbol predeclaration) {
                if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                    OCType symbolType = predeclaration.getType().resolve(predeclaration.getContainingOCFile());
                    return stongEqualer.equal(symbolType);
                }
                return true;
            }
        }, new Condition<OCSymbol>(){

            public boolean value(OCSymbol predeclaration) {
                if (checkTypes && predeclaration instanceof OCFunctionSymbol) {
                    OCType symbolType = predeclaration.getType().resolve(predeclaration.getContainingOCFile());
                    return weakEqualer.isFunctionSignatureEqual(symbolType);
                }
                return true;
            }
        }});
        for (OCSymbol parentSymbol : this.resolveToSymbols(false)) {
            OCType type;
            if (parentSymbol.getKind() == OCSymbolKind.TYPEDEF && (type = parentSymbol.getResolvedType()) instanceof OCStructType) {
                for (OCStructSymbol parentSymbolPart : ((OCStructType)type).getStructs()) {
                    parentSymbolPart.processMembers(symbol.getName(), (Processor<OCSymbol>)processor2);
                }
            }
            if (!(parentSymbol instanceof OCNamespaceSymbol)) continue;
            ((OCNamespaceSymbol)parentSymbol).processMembers(symbol.getName(), (Processor<OCSymbol>)processor2);
        }
        processor2.finish();
        return (OCSymbol)finder.getFoundValue();
    }

    public OCPolyVariantReference<OCSymbol> getReference() {
        return new OCPolyVariantReferenceImpl<OCSymbol>(){

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols() {
                List<OCSymbol> list = OCCppNamespaceQualifierImpl.this.resolveToSymbols(false);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "resolveToSymbols"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "resolveToSymbols"));
                }
                List<OCSymbol> list = OCCppNamespaceQualifierImpl.this.resolveToSymbols(false, context);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "resolveToSymbols"));
                }
                return list;
            }

            public PsiElement getElement() {
                return OCCppNamespaceQualifierImpl.this;
            }

            public TextRange getRangeInElement() {
                return OCCppNamespaceQualifierImpl.this.getRangeInElement();
            }

            @NotNull
            public String getCanonicalText() {
                String name = OCCppNamespaceQualifierImpl.this.getName();
                String string = name != null ? name : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "getCanonicalText"));
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return OCCppNamespaceQualifierImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                if (symbol == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "bindToSymbol"));
                }
                List<OCSymbol> symbols = OCCppNamespaceQualifierImpl.this.getReference().resolveToSymbols();
                if (symbols.contains(symbol)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return OCCppNamespaceQualifierImpl.this;
                }
                OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName();
                if (qualifiedName != null) {
                    OCBindUtil.setShortestPossibleName(qualifiedName, OCCppNamespaceQualifierImpl.this, (OCSymbolWithQualifiedName)symbol);
                }
                return OCCppNamespaceQualifierImpl.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/psi/impl/OCCppNamespaceQualifierImpl$5", "bindToElement"));
                }
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }
}

