/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCCodeFragmentImpl
extends OCFileImpl
implements OCCodeFragment {
    private PsiElement myContext;
    private boolean myPhysical;
    private FileViewProvider myViewProvider;
    private GlobalSearchScope myResolveScope;
    private Condition<OCSymbol> myFilter = null;

    public OCCodeFragmentImpl(Project project, @NonNls String name, CharSequence text, boolean isPhysical, IElementType elementType) {
        super(((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(name, FileTypeManager.getInstance().getFileTypeByFileName(name), text), isPhysical));
        this.myPhysical = isPhysical;
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi(this);
        this.init(TokenType.CODE_FRAGMENT, elementType);
    }

    public OCCodeFragmentImpl(FileViewProvider viewProvider, boolean isPhysical, IElementType elementType) {
        super(viewProvider);
        this.myViewProvider = viewProvider;
        this.myPhysical = isPhysical;
        this.init(TokenType.CODE_FRAGMENT, elementType);
    }

    @Override
    protected OCCodeFragmentImpl clone() {
        OCCodeFragmentImpl clone = (OCCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi(clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCodeFragmentImpl", "getPsiRoots"));
        }
        return psiFileArray;
    }

    @Override
    public PsiElement getContext() {
        OCLog.LOG.assertTrue(this.myContext != this, (Object)"Context cannot be the same element");
        return this.myContext;
    }

    @Override
    public void setContext(PsiElement context) {
        this.myContext = context;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCodeFragmentImpl", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCodeFragmentImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.myContext == null || this.myContext.isValid();
    }

    @Override
    public boolean isPhysical() {
        return super.isPhysical() && this.myPhysical;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        if (this.myResolveScope != null) {
            GlobalSearchScope globalSearchScope = this.myResolveScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCodeFragmentImpl", "getResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCodeFragmentImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    public Condition<OCSymbol> getCompletionFilter() {
        return this.myFilter;
    }

    @Override
    public void setCompletionFilter(Condition<OCSymbol> filter) {
        this.myFilter = filter;
    }
}

