/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCCategoryNameImpl
extends OCElementBase
implements OCCategoryName {
    public OCCategoryNameImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/psi/impl/OCCategoryNameImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/cidr/lang/psi/impl/OCCategoryNameImpl", "accept"));
        }
        visitor.visitCategoryName(this);
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        String string = identifier != null ? identifier.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/OCCategoryNameImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/psi/impl/OCCategoryNameImpl", "setName"));
        }
        PsiElement identifier = this.getNameIdentifier();
        if (!name.isEmpty()) {
            if (identifier != null) {
                OCElementUtil.replaceWithIdentifier(identifier, name, this);
            } else {
                PsiElement newIdentifier = OCElementFactory.createIdentifier(name, this);
                this.addBefore(newIdentifier, (PsiElement)this.findNotNullChildByType(OCTokenTypes.RPAR));
            }
        } else if (identifier != null) {
            OCChangeUtil.delete(identifier);
        }
        return this;
    }
}

